/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.records.MapRecord;

public class RecordJsonifier {
    static RecordJsonifier singleton = new RecordJsonifier();

    public static RecordJsonifier get() {
        return singleton;
    }

    public JsonObject fromRecord(Record r) {
        String key = r.getKey();
        JsonObject res = new JsonObject();
        if (key != null) {
            res.set("key", key);
        }
        res.set("lastModified", r.getLastModified());
        String[] fields = r.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            Object value = r.get(field);
            res.set(field, this.fromJavaValue(value));
        }
        return res;
    }

    public JsonValue fromJavaValue(Object value) {
        if (value instanceof String) {
            return Json.value((String)((String)value));
        }
        if (value instanceof Long) {
            return Json.value((long)((Number)value).longValue());
        }
        if (value instanceof Integer) {
            return Json.value((int)((Number)value).intValue());
        }
        if (value instanceof Number) {
            return Json.value((double)((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return Json.value((boolean)((Boolean)value));
        }
        if (value instanceof Object[]) {
            JsonArray jarr = new JsonArray();
            Object[] arr = (Object[])value;
            for (int j = 0; j < arr.length; ++j) {
                jarr.add(this.fromJavaValue(arr[j]));
            }
            return jarr;
        }
        if (value instanceof Collection) {
            JsonArray jarr = new JsonArray();
            ((Collection)value).forEach(v -> jarr.add(this.fromJavaValue(v)));
            return jarr;
        }
        if (value instanceof Record) {
            return this.fromRecord((Record)value);
        }
        if (value == null) {
            return Json.NULL;
        }
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value instanceof Map) {
            return this.from((Map)value).toJson();
        }
        if (value != null) {
            System.out.println("unmapped data " + value.getClass().getName());
        }
        System.out.println("unmapped data " + value);
        return Json.value((String)("" + value));
    }

    public Object toRecordValue(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).toArray(new Object[((Collection)value).size()]);
        }
        if (value instanceof Map) {
            return this.from((Map)value);
        }
        return value;
    }

    public Record from(Map<String, Object> map) {
        return Record.from(map.entrySet().stream().flatMap(en -> Stream.of(en.getKey(), this.toRecordValue(en.getValue()))).collect(Collectors.toList()).toArray());
    }

    public Record toRecord(JsonObject members) {
        MapRecord aNew = MapRecord.New(null);
        members.names().forEach(field -> {
            if ("key".equals(field)) {
                aNew.key(members.get(field).asString());
                return;
            }
            JsonValue jsonValue = members.get(field);
            if (jsonValue.isString()) {
                aNew.put((String)field, jsonValue.asString());
            } else if (jsonValue.isNull()) {
                aNew.put((String)field, null);
            } else if (jsonValue.isNumber()) {
                if (jsonValue.toString().indexOf(46) >= 0) {
                    aNew.put((String)field, jsonValue.asDouble());
                } else {
                    aNew.put((String)field, jsonValue.asLong());
                }
            } else if (jsonValue.isBoolean()) {
                aNew.put((String)field, jsonValue.asBoolean());
            } else if (jsonValue.isObject()) {
                aNew.put((String)field, this.toRecord(jsonValue.asObject()));
            } else if (jsonValue.isArray()) {
                aNew.put((String)field, this.toRecordArray(jsonValue.asArray()));
            } else {
                throw new RuntimeException("unexpected json type:" + jsonValue.getClass());
            }
        });
        return aNew;
    }

    public Object toJavaValue(JsonValue jsonValue) {
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNull()) {
            return null;
        }
        if (jsonValue.isNumber()) {
            if (jsonValue.toString().indexOf(46) >= 0) {
                return jsonValue.asDouble();
            }
            return jsonValue.asLong();
        }
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        throw new RuntimeException("unexpected json type:" + jsonValue.getClass());
    }

    public Object[] toRecordArray(JsonArray arr) {
        Object[] res = new Object[arr.size()];
        int i = 0;
        for (JsonValue jsonValue : arr) {
            if (jsonValue.isString()) {
                res[i] = jsonValue.asString();
            } else if (jsonValue.isNull()) {
                res[i] = null;
            } else if (jsonValue.isNumber()) {
                res[i] = jsonValue.asDouble();
            } else if (jsonValue.isBoolean()) {
                res[i] = jsonValue.asBoolean();
            } else if (jsonValue.isObject()) {
                res[i] = this.toRecord(jsonValue.asObject());
            } else if (jsonValue.isArray()) {
                res[i] = this.toRecordArray(jsonValue.asArray());
            } else {
                throw new RuntimeException("unexpected json type:" + jsonValue.getClass());
            }
            ++i;
        }
        return res;
    }

    public static JsonObject jsonFrom(Object ... keyVals) {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < keyVals.length; i += 2) {
            String key = (String)keyVals[i];
            Object val = keyVals[i + 1];
            if (val instanceof String) {
                obj.set(key, (String)val);
                continue;
            }
            if (val == null) {
                obj.set(key, Json.NULL);
                continue;
            }
            if (val instanceof Integer) {
                obj.set(key, ((Integer)val).intValue());
                continue;
            }
            if (val instanceof Double) {
                obj.set(key, ((Double)val).doubleValue());
                continue;
            }
            if (val instanceof Long) {
                obj.set(key, ((Long)val).longValue());
                continue;
            }
            if (val instanceof Float) {
                obj.set(key, ((Float)val).floatValue());
                continue;
            }
            if (val instanceof Boolean) {
                obj.set(key, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof JsonObject) {
                obj.set(key, (JsonValue)((JsonObject)val));
                continue;
            }
            if (val instanceof Object[]) {
                Object[] arr = (Object[])val;
                JsonArray jarr = RecordJsonifier.jsonArrayFrom(arr);
                obj.set(key, (JsonValue)jarr);
                continue;
            }
            throw new RuntimeException("unexpected type " + val);
        }
        return obj;
    }

    public static JsonArray jsonArrayFrom(Object ... arr) {
        JsonArray jarr = new JsonArray();
        for (Object o : arr) {
            if (o instanceof String) {
                jarr.add((String)o);
                continue;
            }
            if (o instanceof Integer) {
                jarr.add(((Integer)o).intValue());
                continue;
            }
            if (o instanceof Double) {
                jarr.add(((Double)o).doubleValue());
                continue;
            }
            if (o instanceof Long) {
                jarr.add(((Long)o).longValue());
                continue;
            }
            if (o instanceof Float) {
                jarr.add(((Float)o).floatValue());
                continue;
            }
            if (o instanceof Boolean) {
                jarr.add(((Boolean)o).booleanValue());
                continue;
            }
            if (o instanceof Object[]) {
                jarr.add((JsonValue)RecordJsonifier.jsonArrayFrom((Object[])o));
                continue;
            }
            if (o instanceof JsonObject) {
                jarr.add((JsonValue)((JsonObject)o));
                continue;
            }
            throw new RuntimeException("unexpected type " + o);
        }
        return jarr;
    }

    public static void main(String[] args) {
        JsonObject json = RecordJsonifier.jsonFrom("test", 13, "otherTest", "Hello");
        String key = "9991";
        Record targetRec = Record.from("appointmentProviderClass", Record.from(new Object[0]));
        System.out.println(targetRec.toPrettyString());
        System.out.println();
        Record rec = Record.from("key", key, "availabilityRules+", Record.from("appointmentProviderClass+", Record.from("rec", Record.from(json))));
        System.out.println("merging:");
        System.out.println(rec.toPrettyString());
        System.out.println();
        targetRec.deepMerge(rec);
        System.out.println("result:");
        System.out.println(targetRec.toPrettyString());
        System.out.println();
    }
}

