/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nustaq.kontraktor.Spore;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.offheap.FSTAsciiStringOffheapMap;
import org.nustaq.offheap.FSTSerializedOffheapMap;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.server.storage.ClusterTableRecordMapping;
import org.nustaq.reallive.server.storage.StorageStats;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.simpleapi.DefaultCoder;
import org.nustaq.serialization.simpleapi.FSTCoder;
import org.nustaq.serialization.util.FSTUtil;

public class OffHeapRecordStorage
implements RecordStorage {
    private static final boolean DEBUG = false;
    OutputStream protocol;
    FSTCoder coder;
    FSTSerializedOffheapMap<String, Record> store;
    int keyLen;
    private String tableFile;
    Thread _t;
    static FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();

    protected OffHeapRecordStorage() {
    }

    public OffHeapRecordStorage(int maxKeyLen, int sizeMB, int estimatedNumRecords) {
        this.keyLen = maxKeyLen;
        this.init(null, sizeMB, estimatedNumRecords, maxKeyLen, false, Record.class);
    }

    public OffHeapRecordStorage(String file, int maxKeyLen, int sizeMB, int estimatedNumRecords) {
        this.keyLen = maxKeyLen;
        this.init(file, sizeMB, estimatedNumRecords, maxKeyLen, true, Record.class);
    }

    protected void init(String tableFile, int sizeMB, int estimatedNumRecords, int keyLen, boolean persist, Class ... toReg) {
        this.keyLen = keyLen;
        this.tableFile = tableFile;
        this.coder = new DefaultCoder();
        if (toReg != null) {
            this.coder.getConf().registerClass(toReg);
        }
        if (persist) {
            try {
                this.store = this.createPersistentMap(tableFile, sizeMB, estimatedNumRecords, keyLen);
            }
            catch (Exception e) {
                FSTUtil.rethrow((Throwable)e);
            }
        } else {
            this.store = this.createMemMap(sizeMB, estimatedNumRecords, keyLen);
        }
    }

    protected FSTSerializedOffheapMap<String, Record> createMemMap(int sizeMB, int estimatedNumRecords, int keyLen) {
        return new FSTAsciiStringOffheapMap(keyLen, 0x100000L * (long)sizeMB, estimatedNumRecords, this.coder);
    }

    protected FSTSerializedOffheapMap<String, Record> createPersistentMap(String tableFile, int sizeMB, int estimatedNumRecords, int keyLen) throws Exception {
        boolean fileExists = new File(tableFile).exists();
        try {
            return new FSTAsciiStringOffheapMap(tableFile, keyLen, 0x100000L * (long)sizeMB, estimatedNumRecords, this.coder);
        }
        catch (Exception e) {
            Log.Error((Object)this, (Throwable)e);
            Log.Warn((Object)this, (String)"exception when trying to mount table file, will backup and recover");
            if (fileExists) {
                try {
                    String corruptCopy = tableFile + "_corrupted";
                    Path copied = Paths.get(corruptCopy, new String[0]);
                    Path originalPath = Paths.get(tableFile, new String[0]);
                    Files.copy(originalPath, copied, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(originalPath);
                    return this.createPersistentMap(tableFile, sizeMB, estimatedNumRecords, keyLen);
                }
                catch (Exception ee) {
                    Log.Error((Object)this, (String)"failed to copy/delete corrupt file");
                    Log.Error((Object)this, (Throwable)ee);
                }
            }
            return null;
        }
    }

    @Override
    public StorageStats getStats() {
        StorageStats stats = new StorageStats().name(this.store.getFileName()).capacity(this.store.getCapacityMB()).freeMem(this.store.getFreeMem()).usedMem(this.store.getUsedMem()).numElems(this.store.getSize());
        return stats;
    }

    @Override
    public RecordStorage put(String key, Record value) {
        value.internal_updateLastModified();
        return this._put(key, value);
    }

    @Override
    public RecordStorage _put(String key, Record value) {
        if (this.protocol != null) {
            try {
                FSTConfiguration.getDefaultConfiguration().encodeToStream(this.protocol, (Object)new Object[]{"putRecord", key, value});
                this.protocol.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.store.put((Object)key, (Object)value);
        return this;
    }

    void checkThread() {
        if (this._t == null) {
            this._t = Thread.currentThread();
        } else if (this._t != Thread.currentThread()) {
            throw new RuntimeException("Unexpected MultiThreading");
        }
    }

    @Override
    public Record get(String key) {
        this.checkThread();
        return (Record)this.store.get((Object)key);
    }

    @Override
    public Record remove(String key) {
        Record v;
        if (this.protocol != null) {
            try {
                FSTConfiguration.getDefaultConfiguration().encodeToStream(this.protocol, (Object)new Object[]{"remove", key});
                this.protocol.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((v = this.get(key)) != null) {
            this.store.remove((Object)key);
            v.internal_updateLastModified();
        }
        return v;
    }

    @Override
    public long size() {
        return this.store.getSize();
    }

    @Override
    public Stream<Record> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.store.values(), 1024), false);
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrow) {
        double lf = (double)this.store.getUsedMem() / (double)(this.store.getUsedMem() + this.store.getFreeMem());
        if (lf >= loadFactor) {
            this.store.resizeStore((long)this.store.getCapacityMB() * 1024L * 1024L * 2L, maxGrow);
        }
    }

    @Override
    public <T> void forEachWithSpore(Spore<Record, T> spore) {
        Iterator iterator = this.store.values();
        while (iterator.hasNext()) {
            try {
                Record record = (Record)iterator.next();
                spore.remote((Object)record);
            }
            catch (Throwable ex) {
                Log.Error((Object)this, (Throwable)ex, (String)("exception in spore " + ex));
            }
            if (!spore.isFinished()) continue;
        }
        spore.finish();
    }

    @Override
    public void _saveMapping(ClusterTableRecordMapping mapping) {
        if (this.tableFile != null) {
            String noExt = this.tableFile.substring(0, this.tableFile.lastIndexOf("."));
            try {
                Files.write(new File(noExt + ".mapping").toPath(), conf.asByteArray((Object)mapping), new OpenOption[0]);
            }
            catch (IOException e) {
                Log.Error((Object)this, (Throwable)e);
            }
        }
    }

    @Override
    public ClusterTableRecordMapping _loadMapping() {
        if (this.tableFile != null) {
            String noExt = this.tableFile.substring(0, this.tableFile.lastIndexOf("."));
            try {
                File f = new File(noExt + ".mapping");
                if (!f.exists()) {
                    return null;
                }
                return (ClusterTableRecordMapping)conf.asObject(Files.readAllBytes(f.toPath()));
            }
            catch (IOException e) {
                Log.Error((Object)this, (Throwable)e);
            }
        }
        return null;
    }
}

