/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.api.StorageIndex;
import org.nustaq.reallive.server.storage.ClusterTableRecordMapping;
import org.nustaq.reallive.server.storage.HashIndex;
import org.nustaq.reallive.server.storage.RecordPersistance;
import org.nustaq.reallive.server.storage.StorageStats;

public class IndexedRecordStorage
implements RecordStorage {
    RecordStorage wrapped;
    List<StorageIndex> indices = new ArrayList<StorageIndex>();
    Map<String, HashIndex> hashIndizes = new HashMap<String, HashIndex>();

    public IndexedRecordStorage wrapped(RecordStorage r) {
        this.wrapped = r;
        return this;
    }

    public RecordStorage getWrapped() {
        return this.wrapped;
    }

    public List<StorageIndex> getIndices() {
        return this.indices;
    }

    public void addIndex(StorageIndex s) {
        this.indices.add(s);
        if (s instanceof HashIndex) {
            this.hashIndizes.put(((HashIndex)s).getHashPath(), (HashIndex)s);
        }
    }

    @Override
    public RecordStorage put(String key, Record value) {
        if (this.indices != null) {
            this.indices.forEach(ind -> ind.put(value.getKey(), value));
        }
        return this.wrapped.put(key, value);
    }

    @Override
    public RecordPersistance _put(String key, Record value) {
        return this.put(key, value);
    }

    public void initializeFromRecord(Record value) {
        if (this.indices != null) {
            this.indices.forEach(ind -> ind.put(value.getKey(), value));
        }
    }

    @Override
    public Record get(String key) {
        return this.wrapped.get(key);
    }

    @Override
    public Record remove(String key) {
        if (this.indices != null) {
            this.indices.forEach(ind -> ind.remove(key));
        }
        return this.wrapped.remove(key);
    }

    @Override
    public long size() {
        return this.wrapped.size();
    }

    @Override
    public StorageStats getStats() {
        return this.wrapped.getStats();
    }

    @Override
    public Stream<Record> stream() {
        return this.wrapped.stream();
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrow) {
        this.wrapped.resizeIfLoadFactorLarger(loadFactor, maxGrow);
    }

    @Override
    public <T> void forEachWithSpore(Spore<Record, T> spore) {
        this.wrapped.forEachWithSpore(spore);
    }

    public HashIndex getHashIndex(String path) {
        return this.hashIndizes.get(path);
    }

    @Override
    public void _saveMapping(ClusterTableRecordMapping mapping) {
        this.wrapped._saveMapping(mapping);
    }

    @Override
    public ClusterTableRecordMapping _loadMapping() {
        return this.wrapped._loadMapping();
    }
}

