/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.api.StorageIndex;

public class HashIndex
implements StorageIndex {
    private final String hashPath;
    RLFunction<Record, Object> hashGetter;
    Object2ObjectOpenHashMap<Object, Set<String>> index = new Object2ObjectOpenHashMap();
    Object2ObjectOpenHashMap<String, Object> key2HashVal = new Object2ObjectOpenHashMap();

    public HashIndex(RLFunction<Record, Object> hashGetter, String hashPath) {
        this.hashGetter = hashGetter;
        this.hashPath = hashPath;
    }

    public String getHashPath() {
        return this.hashPath;
    }

    public RLFunction<Record, Object> getHashGetter() {
        return this.hashGetter;
    }

    public Map<Object, Set<String>> getIndex() {
        return this.index;
    }

    public Map<String, Object> getKey2HashVal() {
        return this.key2HashVal;
    }

    @Override
    public void put(String key, Record value) {
        Object oldHKey;
        Object hkey = HashIndex.unifyKey(this.hashGetter.apply(value));
        if (hkey.equals(oldHKey = this.key2HashVal.get((Object)key))) {
            return;
        }
        if (oldHKey != null) {
            ((Set)this.index.get(oldHKey)).remove(key);
        }
        this.key2HashVal.put((Object)key, hkey);
        HashSet<String> strings = (HashSet<String>)this.index.get(hkey);
        if (strings == null) {
            strings = new HashSet<String>();
            this.index.put(hkey, strings);
        }
        strings.add(key);
    }

    public static Object unifyKey(Object key) {
        if (key instanceof Byte || key instanceof Short || key instanceof Integer || key instanceof Long) {
            return ((Number)key).longValue();
        }
        if (key instanceof Float || key instanceof Double) {
            return ((Number)key).doubleValue();
        }
        if (key == null) {
            return "_NULL_";
        }
        return key;
    }

    @Override
    public void remove(String key) {
        Object oldHVal = this.key2HashVal.get((Object)key);
        ((Set)this.index.get(oldHVal)).remove(key);
        this.key2HashVal.remove((Object)key);
    }

    @Override
    public <T> void forEachWithSpore(Object hashValue, Spore<Record, T> spore, RecordStorage store) {
        Set strings = (Set)this.index.get(hashValue);
        if (strings == null) {
            spore.finish();
            return;
        }
        for (String key : strings) {
            Record record = store.get(key);
            if (record == null) {
                Log.Error((Object)this, (String)("inconsistent index, no record found for " + key));
            }
            try {
                spore.remote((Object)record);
            }
            catch (Throwable ex) {
                Log.Warn((Object)this, (Throwable)ex, (String)("exception in spore " + spore));
                throw ex;
            }
            if (!spore.isFinished()) continue;
            break;
        }
        spore.finish();
    }

    public static void main(String[] args) {
        HashMap<Object, String> mp = new HashMap<Object, String>();
        mp.put(HashIndex.unifyKey((byte)125), "Hello");
        System.out.println(mp.get(HashIndex.unifyKey(125)) + " " + mp.get(HashIndex.unifyKey(125L)));
    }

    public Stream<String> getKeys(Object key) {
        return this.getKeySet(key).stream();
    }

    public Set<String> getKeySet(Object key) {
        Set strings = (Set)this.index.get(HashIndex.unifyKey(key));
        if (strings == null) {
            return Collections.emptySet();
        }
        return strings;
    }
}

