/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import java.util.function.Function;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.server.storage.StorageStats;

public class EncryptedStorageWrapper
implements RecordStorage {
    Function<Record, Record> encryptionFun = r -> r;
    Function<Record, Record> decryptionFun = r -> r;
    RecordStorage wrapped;

    public EncryptedStorageWrapper(Function<Record, Record> encryptionFun, Function<Record, Record> decryptionFun, RecordStorage wrapped) {
        this.encryptionFun = encryptionFun;
        this.decryptionFun = decryptionFun;
        this.wrapped = wrapped;
    }

    @Override
    public RecordStorage put(String key, Record value) {
        return this.wrapped.put(key, this.encryptionFun.apply(value));
    }

    @Override
    public Record get(String key) {
        return this.decryptionFun.apply(this.wrapped.get(key));
    }

    @Override
    public Record remove(String key) {
        return this.decryptionFun.apply(this.wrapped.remove(key));
    }

    @Override
    public long size() {
        return this.wrapped.size();
    }

    @Override
    public StorageStats getStats() {
        return this.wrapped.getStats();
    }

    @Override
    public Stream<Record> stream() {
        return this.wrapped.stream().map(this.decryptionFun);
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrow) {
        this.wrapped.resizeIfLoadFactorLarger(loadFactor, maxGrow);
    }

    @Override
    public <T> void forEachWithSpore(final Spore<Record, T> spore) {
        this.wrapped.forEachWithSpore(new Spore<Record, Object>(){

            public void remote(Record input) {
                spore.remote((Object)EncryptedStorageWrapper.this.decryptionFun.apply(input));
            }
        });
    }
}

