/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import java.io.Serializable;
import java.util.BitSet;
import java.util.UUID;

public class ClusterTableRecordMapping
implements Serializable {
    BitSet bs = new BitSet();
    public static final int NUM_BUCKET = 32;

    public static ClusterTableRecordMapping Copy(ClusterTableRecordMapping old) {
        ClusterTableRecordMapping nm = new ClusterTableRecordMapping();
        nm.addBuckets(old.getBucketsAsIA());
        return nm;
    }

    public boolean matches(int hashKey) {
        int bucket = this.getBucket(hashKey);
        return this.bs.get(bucket);
    }

    public int getBucket(int hashKey) {
        return (hashKey & Integer.MAX_VALUE) % 32;
    }

    public void addBuckets(int[] buckets) {
        for (int i = 0; i < buckets.length; ++i) {
            this.bs.set(buckets[i], true);
        }
    }

    public int[] getBucketsAsIA() {
        int[] res = new int[this.bs.cardinality()];
        int resC = 0;
        for (int i = 0; i < 32; ++i) {
            if (!this.bs.get(i)) continue;
            res[resC++] = i;
        }
        return res;
    }

    public void setBucket(int index, boolean b) {
        this.bs.set(index, b);
    }

    public static void checkBucket(ClusterTableRecordMapping[] mappings, int num) {
        for (int i = 0; i < mappings.length; ++i) {
            ClusterTableRecordMapping mapping = mappings[i];
            mapping.matches(num);
        }
    }

    public static void main(String[] args) {
        ClusterTableRecordMapping[] mappings = new ClusterTableRecordMapping[31];
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i] = new ClusterTableRecordMapping();
            mappings[i].setBucket((int)(Math.random() * 32.0), true);
        }
        int hash = UUID.randomUUID().toString().hashCode();
        while (true) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < 1000000; ++i) {
                ClusterTableRecordMapping.checkBucket(mappings, hash);
            }
            System.out.println("tim " + (System.currentTimeMillis() - now));
        }
    }

    public String toString() {
        return "ClusterRecordMapping{bs=" + this.bs + "}";
    }

    public BitSet getBitset() {
        return this.bs;
    }

    public void remove(int[] hashShards2Move) {
        for (int i = 0; i < hashShards2Move.length; ++i) {
            int shard = hashShards2Move[i];
            this.setBucket(shard, false);
        }
    }
}

