/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.storage;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.records.MapRecord;
import org.nustaq.reallive.server.StorageDriver;
import org.nustaq.reallive.server.storage.ClusterTableRecordMapping;
import org.nustaq.reallive.server.storage.HeapRecordStorage;
import org.nustaq.reallive.server.storage.RecordPersistance;
import org.nustaq.reallive.server.storage.StorageStats;

public class CachedOffHeapStorage
implements RecordStorage {
    RecordPersistance persisted;
    HeapRecordStorage onHeap;

    public CachedOffHeapStorage(RecordPersistance persisted, final HeapRecordStorage onHeap) {
        this.persisted = persisted;
        this.onHeap = onHeap;
        final ArrayList reput = new ArrayList();
        persisted.forEachWithSpore(new Spore<Record, Object>(){
            boolean hadErr = false;

            public void remote(Record input) {
                try {
                    Record unwrap = StorageDriver.unwrap(input);
                    if (unwrap != input) {
                        reput.add(unwrap);
                    }
                    if (unwrap.getClass() != MapRecord.recordClass && MapRecord.conversion != null) {
                        unwrap = MapRecord.conversion.apply((MapRecord)unwrap);
                        reput.add(unwrap);
                    }
                    onHeap._put(input.getKey(), unwrap);
                }
                catch (Exception e) {
                    if (this.hadErr) {
                        Log.Error((Object)((Object)this), (String)("no trace (repetition): " + e));
                    }
                    this.hadErr = true;
                    Log.Error((Object)((Object)this), (Throwable)e);
                }
            }
        }.onFinish(() -> {
            for (int i = 0; i < reput.size(); ++i) {
                Record record = (Record)reput.get(i);
                persisted._put(record.getKey(), record);
            }
        }));
    }

    @Override
    public RecordStorage put(String key, Record value) {
        value.internal_updateLastModified();
        this.persisted._put(key, value);
        this.onHeap._put(key, value);
        return this;
    }

    @Override
    public Record get(String key) {
        return this.onHeap.get(key);
    }

    @Override
    public Record remove(String key) {
        this.persisted.remove(key);
        Record res = this.onHeap.remove(key);
        return res;
    }

    @Override
    public long size() {
        return this.onHeap.size();
    }

    @Override
    public StorageStats getStats() {
        return this.persisted.getStats();
    }

    @Override
    public Stream<Record> stream() {
        return this.onHeap.stream();
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrowBytes) {
        this.persisted.resizeIfLoadFactorLarger(loadFactor, maxGrowBytes);
    }

    @Override
    public <T> void forEachWithSpore(Spore<Record, T> spore) {
        this.onHeap.forEachWithSpore(spore);
    }

    @Override
    public void _saveMapping(ClusterTableRecordMapping mapping) {
        this.persisted._saveMapping(mapping);
    }

    @Override
    public ClusterTableRecordMapping _loadMapping() {
        return this.persisted._loadMapping();
    }
}

