/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.dynamic;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.TableState;
import org.nustaq.reallive.server.dynamic.actions.ClusterTableAction;

public class DynClusterTableDistribution
implements Serializable {
    List<TableState> tableStates = new ArrayList<TableState>();
    List<ClusterTableAction> actions;
    private String name;
    public static final int OK = 0;
    public static final int INTERSECT = 1;
    public static final int INCOMPLETE = 2;
    public static final int EMPTY = 4;
    public static final int TABLE_MISSING = 8;

    public DynClusterTableDistribution(String name) {
        this.name = name;
    }

    public List<TableState> getStates() {
        return this.tableStates;
    }

    public int sanitize() {
        List<TableState> l = this.tableStates;
        int res = 0;
        int numNodes = -1;
        BitSet bs = new BitSet(32);
        for (int i = 0; i < l.size(); ++i) {
            TableState tableState = l.get(i);
            if (numNodes < 0) {
                numNodes = l.size();
            } else if (l.size() != numNodes) {
                res |= 8;
            }
            BitSet tableBS = tableState.getMapping().getBitset();
            if (bs.intersects(tableBS)) {
                Log.Warn((Object)this, (String)("data intersection " + tableState));
                res |= 1;
            }
            bs.or(tableBS);
        }
        if (bs.nextClearBit(0) != 32) {
            res |= 2;
        }
        if (bs.isEmpty()) {
            res |= 4;
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(TableState value) {
        this.tableStates.add(value);
    }

    public List<ClusterTableAction> getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<ClusterTableAction>();
        }
        return this.actions;
    }

    public void addAction(ClusterTableAction action) {
        this.getActions().add(action);
    }

    public void setActions(List<ClusterTableAction> actions) {
        this.actions = actions;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(100);
        s.append("=> " + this.getName() + "\n");
        this.tableStates.forEach(ts -> s.append(ts.getAssociatedShardName() + " " + ts.getMapping() + " " + ts.getNumElements() + "\n"));
        s.append("\n");
        return s.toString();
    }

    public JsonObject toJsonObj() {
        JsonObject res = new JsonObject();
        res.set("table", this.getName());
        JsonArray array = new JsonArray();
        res.set("distribution", (JsonValue)array);
        this.tableStates.forEach(ts -> {
            JsonObject ob = new JsonObject();
            array.add((JsonValue)ob);
            ob.set("shard", ts.getAssociatedShardName());
            ob.set("elements", ts.getNumElements());
            JsonArray mapArr = new JsonArray();
            ob.set("mapping", (JsonValue)mapArr);
            int[] buckets = ts.getMapping().getBucketsAsIA();
            for (int i = 0; i < buckets.length; ++i) {
                mapArr.add(buckets[i]);
            }
        });
        return res;
    }

    public void clearActions() {
        this.actions = null;
    }

    public boolean covers(int i) {
        for (int j = 0; j < this.tableStates.size(); ++j) {
            TableState tableState = this.tableStates.get(j);
            if (!tableState.containsBucket(i)) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<ClusterTableAction>> collectByTarget() {
        HashMap<String, List<ClusterTableAction>> res = new HashMap<String, List<ClusterTableAction>>();
        this.actions.forEach(action -> {
            ArrayList<ClusterTableAction> actions = (ArrayList<ClusterTableAction>)res.get(action.getShardName());
            if (actions == null) {
                actions = new ArrayList<ClusterTableAction>();
                res.put(action.getShardName(), actions);
            }
            actions.add((ClusterTableAction)action);
        });
        return res;
    }
}

