/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.dynamic;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nustaq.reallive.api.TableState;
import org.nustaq.reallive.server.actors.RealLiveTableActor;
import org.nustaq.reallive.server.dynamic.DynClusterTableDistribution;

public class DynClusterDistribution
implements Serializable {
    Map<String, DynClusterTableDistribution> distributions = new HashMap<String, DynClusterTableDistribution>();

    public void add(DynClusterTableDistribution ts) {
        if (this.distributions.containsKey(ts.getName())) {
            throw new RuntimeException("double distribution" + ts.getName());
        }
        this.distributions.put(ts.getName(), ts);
    }

    public DynClusterTableDistribution have(String name) {
        DynClusterTableDistribution res = this.distributions.get(name);
        if (res == null) {
            res = new DynClusterTableDistribution(name);
            this.distributions.put(name, res);
        }
        return res;
    }

    public DynClusterTableDistribution get(String name) {
        return this.distributions.get(name);
    }

    public Collection<String> getTableNames() {
        return this.distributions.keySet();
    }

    public void clearActions() {
        this.distributions.values().forEach(tdist -> tdist.clearActions());
    }

    public int getNumberOfShards() {
        if (this.distributions == null) {
            return 0;
        }
        if (this.distributions.isEmpty()) {
            return 0;
        }
        return this.distributions.values().iterator().next().getStates().size();
    }

    public Map<String, DynClusterTableDistribution> getDistributions() {
        return this.distributions;
    }

    public void setTableActor(String table, String shardName, RealLiveTableActor realLiveTableActor) {
        List<TableState> states = this.distributions.get(table).getStates();
        for (int i = 0; i < states.size(); ++i) {
            TableState tableState = states.get(i);
            if (!tableState.getAssociatedShardName().equals(shardName)) continue;
            tableState.associatedTableShard(realLiveTableActor);
        }
    }

    public boolean hasFullCoverage() {
        for (DynClusterTableDistribution dynClusterTableDistribution : this.distributions.values()) {
            if (dynClusterTableDistribution.sanitize() == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder res = new StringBuilder(200);
        this.distributions.forEach((k, v) -> res.append(v));
        return res.toString();
    }

    public JsonObject toJsonObj() {
        JsonObject res = new JsonObject();
        this.distributions.forEach((k, v) -> res.set(k, (JsonValue)v.toJsonObj()));
        return res;
    }
}

