/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.server.actors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.api.TableSpace;
import org.nustaq.reallive.client.EmbeddedRealLive;
import org.nustaq.reallive.messages.StateMessage;
import org.nustaq.reallive.server.actors.RealLiveTableActor;

public class TableSpaceActor
extends Actor<TableSpaceActor>
implements TableSpace {
    public static long MAX_WAIT_MMAP = TimeUnit.MINUTES.toMillis(5L);
    public transient String __clientsideTag;
    protected HashMap<String, RealLiveTableActor> tables;
    protected HashMap<String, TableDescription> tableDesc;
    protected List<Callback<StateMessage>> stateListeners;
    protected String baseDir;

    @Local
    public void init() {
        this.tables = new HashMap();
        this.stateListeners = new ArrayList<Callback<StateMessage>>();
        this.tableDesc = new HashMap();
    }

    public void setBaseDataDir(String dir) {
        this.baseDir = dir;
    }

    protected String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public IPromise<RealLiveTable> createOrLoadTable(TableDescription desc) {
        if (this.tables.containsKey(desc.getName())) {
            return TableSpaceActor.resolve((Object)this.tables.get(desc.getName()));
        }
        RealLiveTableActor table = this.createTableActor(desc);
        this.tables.put(desc.getName(), table);
        return TableSpaceActor.resolve((Object)table);
    }

    protected RealLiveTableActor createTableActor(TableDescription desc) {
        return (RealLiveTableActor)EmbeddedRealLive.get().createTable(desc, this.getBaseDir()).await(MAX_WAIT_MMAP);
    }

    @Override
    public IPromise dropTable(String name) {
        RealLiveTable realLiveTable = this.tables.get(name);
        if (name != null) {
            this.tables.remove(name);
            ((Actor)realLiveTable).stop();
        }
        return TableSpaceActor.resolve();
    }

    @Override
    public IPromise<List<TableDescription>> getTableDescriptions() {
        return TableSpaceActor.resolve(new ArrayList<TableDescription>(this.tableDesc.values()));
    }

    @Override
    public IPromise<List<RealLiveTable>> getTables() {
        return TableSpaceActor.resolve(new ArrayList<RealLiveTableActor>(this.tables.values()));
    }

    @Override
    public IPromise<RealLiveTable> getTableAsync(String name) {
        return TableSpaceActor.resolve((Object)this.tables.get(name));
    }

    @Override
    public IPromise shutDown() {
        this.tables.values().forEach(table -> table.stop());
        TableSpaceActor.stream((Object[])new SimpleScheduler[]{(SimpleScheduler)this.getScheduler()}).forEach(scheduler -> {
            scheduler.setKeepAlive(false);
            scheduler.terminateIfIdle();
        });
        return TableSpaceActor.resolve();
    }

    @Override
    public void stateListener(Callback<StateMessage> stateListener) {
        this.stateListeners.add(stateListener);
    }
}

