/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.records;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.server.RLUtil;

public class MapRecord
implements Record {
    public static Function<Object, Boolean> JDK_TYPE_CHECK = value -> {
        Class<?> clazz = value.getClass();
        String name = clazz.getName();
        if (MapRecord.isSimpleType(name) || clazz.isArray() && (clazz.getComponentType().isPrimitive() || MapRecord.isSimpleType(clazz.getComponentType().getName()))) {
            return true;
        }
        return false;
    };
    public static Function<Object, Boolean> JSON_CHECKER = value -> {
        Class<?> clazz = value.getClass();
        String name = clazz.getName();
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Record || value instanceof Object[]) {
            return true;
        }
        return false;
    };
    static Function<Object, Boolean> CHECK_TYPES = JDK_TYPE_CHECK;
    public static Class<? extends MapRecord> recordClass = MapRecord.class;
    public static Function<MapRecord, MapRecord> conversion;
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected transient String[] fields;
    protected String key;
    protected long lastModified;
    protected long seq;

    static MapRecord New() {
        try {
            return recordClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected MapRecord() {
    }

    public static MapRecord New(String key) {
        MapRecord mapRecord = MapRecord.New();
        mapRecord.key = key;
        return mapRecord;
    }

    public static MapRecord New(String key, Object ... values) {
        MapRecord mapRecord = MapRecord.New(key);
        RLUtil.get().buildRecord(mapRecord, values);
        return mapRecord;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void internal_setLastModified(long tim) {
        this.lastModified = tim;
    }

    @Override
    public void internal_incSequence() {
        ++this.seq;
    }

    @Override
    public long getSequence() {
        return this.seq;
    }

    @Override
    public Record internal_put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Record key(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String[] getFields() {
        if (this.fields == null) {
            this.fields = new String[this.map.size()];
            this.map.keySet().toArray(this.fields);
        }
        return this.fields;
    }

    @Override
    public Object get(String field) {
        return this.map.get(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MapRecord put(String key, Object value) {
        if (this.map.put(key, value) == null) {
            this.fields = null;
        }
        if (value == null || "_NULL_".equals(value)) {
            this.map.remove(key);
            return this;
        } else if (CHECK_TYPES != null) {
            if (!CHECK_TYPES.apply(value).booleanValue()) throw new RuntimeException("tried to store non-allowed value types " + (value != null ? value.getClass().getName() : "null"));
            this.map.put(key, value);
            return this;
        } else {
            this.map.put(key, value);
        }
        return this;
    }

    private static boolean isSimpleType(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.equals(MapRecord.class.getName());
    }

    public String toString() {
        return "MapRecord{" + this.asString() + "}";
    }

    @Override
    public MapRecord copied() {
        MapRecord newReq = MapRecord.New(this.getKey());
        this.map.forEach((k, v) -> newReq.put((String)k, v));
        newReq.internal_setLastModified(this.lastModified);
        newReq.internal_setSeq(this.seq);
        return newReq;
    }

    private void internal_setSeq(long seq) {
        this.seq = seq;
    }
}

