/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.nustaq.reallive.api.RLHashIndexPredicate;
import org.nustaq.reallive.query.ArrayValue;
import org.nustaq.reallive.query.BooleanValue;
import org.nustaq.reallive.query.CompiledQuery;
import org.nustaq.reallive.query.DoubleValue;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.Evaluator;
import org.nustaq.reallive.query.FuncOperand;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.Operator;
import org.nustaq.reallive.query.QScanner;
import org.nustaq.reallive.query.QStack;
import org.nustaq.reallive.query.QToken;
import org.nustaq.reallive.query.Query;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.query.VarPath;
import org.nustaq.reallive.records.MapRecord;

public class Parser {
    HashMap<String, FuncOperand> functions;
    HashMap<String, Operator> operators;
    private final String SEPARATOR = ",";
    private QStack stackOperations = new QStack();
    private QStack stackRPN = new QStack();
    private QStack stackAnswer = new QStack();
    private List tokenList = new ArrayList();
    protected EvalContext[] ctxRef;

    Parser(HashMap<String, FuncOperand> functions, HashMap<String, Operator> operators) {
        this.functions = functions;
        this.operators = operators;
    }

    public CompiledQuery compile(String query) {
        this.ctxRef = new EvalContext[1];
        this.parse(query);
        CompiledQuery compiledQuery = new CompiledQuery(new Evaluator(this.stackRPN).evaluate(), this.ctxRef).hashIndex(this.checkForIndex());
        return compiledQuery;
    }

    private RLHashIndexPredicate checkForIndex() {
        if (this.tokenList.size() >= 4 ? this.tokenList.get(0) instanceof VarPath && this.tokenList.get(1) instanceof Operator && ((Operator)this.tokenList.get(1)).getName().equals("==") && this.tokenList.get(2) instanceof Value && this.tokenList.get(3) instanceof Operator && ((Operator)this.tokenList.get(3)).getName().equals("&&") : this.tokenList.size() == 3 && this.tokenList.get(0) instanceof VarPath && this.tokenList.get(1) instanceof Operator && ((Operator)this.tokenList.get(1)).getName().equals("==") && this.tokenList.get(2) instanceof Value) {
            return new RLHashIndexPredicate(((VarPath)this.tokenList.get(0)).getPath(), ((Value)this.tokenList.get(2)).getValue(), null);
        }
        return null;
    }

    public List getTokenList() {
        return this.tokenList;
    }

    protected void parse(String expression) {
        QToken token;
        this.stackOperations.clear();
        this.stackRPN.clear();
        this.tokenList.clear();
        QScanner scanner = new QScanner(expression);
        QToken prevToken = null;
        while ((token = scanner.readNext()) != null) {
            Serializable val;
            String tokenValue = token.getValue();
            if (this.isSeparator(tokenValue)) {
                this.tokenList.add(token);
                if (this.stackOperations.empty() || !this.isOpenEckig(this.stackOperations.lastElement().toString())) {
                    while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement().toString())) {
                        this.stackRPN.push(this.stackOperations.pop());
                    }
                }
            } else if (this.isOpenEckig(tokenValue)) {
                this.tokenList.add(token);
                this.stackRPN.push(tokenValue);
                this.stackOperations.push(tokenValue);
            } else if (this.isCloseEckig(tokenValue)) {
                this.tokenList.add(token);
                while (!this.stackOperations.empty() && !this.isOpenEckig(this.stackOperations.lastElement().toString())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                while (!this.stackRPN.empty() && !this.isOpenEckig(this.stackRPN.lastElement().toString())) {
                    arr.add(this.stackRPN.pop());
                }
                this.stackRPN.pop();
                this.stackOperations.pop();
                this.stackRPN.push(new ArrayValue(arr.toArray(), token));
            } else if (this.isOpenBracket(tokenValue)) {
                Object last;
                this.tokenList.add(token);
                Object object = last = this.stackRPN.isEmpty() ? null : this.stackRPN.lastElement();
                if (last instanceof VarPath && this.isFunction(((VarPath)last).field)) {
                    this.stackRPN.pop();
                    this.stackOperations.push(this.functions.get(((VarPath)last).field));
                }
                this.stackOperations.push(token);
            } else if (this.isCloseBracket(tokenValue)) {
                this.tokenList.add(token);
                while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement().toString())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.pop();
                if (!this.stackOperations.empty() && this.stackOperations.lastElement() instanceof FuncOperand) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
            } else if (this.isNumber(tokenValue)) {
                if (tokenValue.indexOf(46) < 0) {
                    Long i = Long.parseLong(tokenValue);
                    LongValue val2 = new LongValue(i, token);
                    this.stackRPN.push(val2);
                    this.tokenList.add(val2);
                } else {
                    Double d = Double.parseDouble(tokenValue);
                    DoubleValue val3 = new DoubleValue(d, token);
                    this.stackRPN.push(val3);
                    this.tokenList.add(val3);
                }
            } else if (this.operators.containsKey(tokenValue)) {
                Operator op = this.operators.get(tokenValue);
                boolean prefix = false;
                if ((tokenValue.equals("+") || tokenValue.equals("-")) && (prevToken == null || this.operators.containsKey(prevToken.getValue()) || this.isOpenBracket(prevToken.getValue()) || this.isOpenEckig(prevToken.getValue()) || this.isSeparator(prevToken.getValue()))) {
                    prefix = true;
                    LongValue val4 = new LongValue(0L, token);
                    this.stackRPN.push(val4);
                }
                while (!this.stackOperations.empty() && !prefix && this.stackOperations.lastElement() instanceof Operator && op.getPrecedence() <= ((Operator)this.stackOperations.lastElement()).getPrecedence()) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.tokenList.add(op);
                this.stackOperations.push(op);
            } else if (tokenValue.startsWith("'") && tokenValue.endsWith("'")) {
                val = new StringValue(tokenValue.substring(1, tokenValue.length() - 1), token);
                this.tokenList.add(val);
                this.stackRPN.push(val);
            } else if (tokenValue.startsWith("\"") && tokenValue.endsWith("\"")) {
                val = new StringValue(tokenValue.substring(1, tokenValue.length() - 1), token);
                this.stackRPN.push(val);
                this.tokenList.add(val);
            } else if ("true".equals(tokenValue)) {
                val = new BooleanValue(true, token);
                this.stackRPN.push(val);
                this.tokenList.add(val);
            } else if ("false".equals(tokenValue)) {
                val = new BooleanValue(false, token);
                this.stackRPN.push(val);
                this.tokenList.add(val);
            } else {
                val = new VarPath(tokenValue, this.ctxRef, token);
                this.stackRPN.push(val);
                this.tokenList.add(val);
            }
            prevToken = token;
        }
        while (!this.stackOperations.empty()) {
            this.stackRPN.push(this.stackOperations.pop());
        }
        Collections.reverse(this.stackRPN);
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isFunction(String token) {
        return this.functions.containsKey(token);
    }

    private boolean isSeparator(String token) {
        return token.equals(",");
    }

    private boolean isOpenBracket(String token) {
        return "(".equals(token);
    }

    private boolean isCloseBracket(String token) {
        return token.equals(")");
    }

    private boolean isOpenEckig(String token) {
        return "[".equals(token);
    }

    private boolean isCloseEckig(String token) {
        return token.equals("]");
    }

    public static void main(String[] args) throws Throwable {
        Parser p = Query.newParser();
        MapRecord hm = MapRecord.New("key").put("test", "hallo").put("a", 100).put("arr", new Object[]{100, "hallo", 3}).put("c", -1).put("time", System.currentTimeMillis()).put("b", 200);
        Parser.testArray(p, hm);
        Thread.sleep(2000L);
        CompiledQuery nums = Query.compile("c!= -1");
        System.out.println(nums.evaluate(hm));
        CompiledQuery ctrue = Query.compile("time < age(1,'sec')");
        CompiledQuery cfalse = Query.compile("time < age(5,'sec')");
        CompiledQuery tim = Query.compile("a<1000000000");
        CompiledQuery trUe = Query.compile("1");
        System.out.println(ctrue.evaluate(hm));
        System.out.println(cfalse.evaluate(hm));
        System.out.println(tim.evaluate(hm));
        System.out.println(trUe.evaluate(hm).isTrue());
    }

    protected static void testArray(Parser p, MapRecord hm) {
        CompiledQuery compile = p.compile("'hallo' ** [1,2,'ha'+'llo']");
        Value evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,50+50]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,100]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,a]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("100 ** [1,2,a]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo' ** [1,2,test]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo' ** arr");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("1 ** arr");
        evaluate = compile.evaluate(hm);
        if (evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("3 ** arr");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo1' ** arr");
        evaluate = compile.evaluate(hm);
        if (evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        System.out.println("testArray success");
    }
}

