/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.io.Serializable;
import org.nustaq.reallive.query.ArrayValue;
import org.nustaq.reallive.query.FuncOperand;
import org.nustaq.reallive.query.HasToken;
import org.nustaq.reallive.query.Operator;
import org.nustaq.reallive.query.QParseException;
import org.nustaq.reallive.query.QStack;
import org.nustaq.reallive.query.RLSupplier;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.query.VarPath;

public class Evaluator
implements Serializable {
    private QStack stackRPN;
    private QStack stackAnswer = new QStack();

    public Evaluator(QStack stackRPN) {
        this.stackRPN = stackRPN;
    }

    public RLSupplier<Value> evaluate() {
        return this.evaluate(false);
    }

    public RLSupplier<Value> evaluate(boolean valueArray) {
        if (this.stackRPN.empty()) {
            return () -> new StringValue("", null);
        }
        this.stackAnswer.clear();
        QStack stackRPN = (QStack)this.stackRPN.clone();
        while (!stackRPN.empty()) {
            Object token = stackRPN.pop();
            if (token instanceof ArrayValue) {
                ArrayValue val = (ArrayValue)token;
                this.stackAnswer.push(val.getEval());
                continue;
            }
            if (token instanceof Value) {
                this.stackAnswer.push(() -> token);
                continue;
            }
            if (token instanceof Operator) {
                RLSupplier a;
                int arity = ((Operator)token).getArity();
                if (arity == 2) {
                    a = (RLSupplier)this.stackAnswer.pop();
                    RLSupplier b = (RLSupplier)this.stackAnswer.pop();
                    this.stackAnswer.push(((Operator)token).getEval(a, b));
                    continue;
                }
                a = (RLSupplier)this.stackAnswer.pop();
                this.stackAnswer.push(((Operator)token).getEval(a, null));
                continue;
            }
            if (token instanceof VarPath) {
                VarPath vp = (VarPath)token;
                this.stackAnswer.push(vp.getEval());
                continue;
            }
            if (!(token instanceof FuncOperand)) continue;
            FuncOperand func = (FuncOperand)token;
            if (func.getArity() < 0) {
                int size = this.stackAnswer.size();
                RLSupplier[] args = new RLSupplier[size];
                for (int i = 0; i < size; ++i) {
                    args[size - i - 1] = (RLSupplier)this.stackAnswer.pop();
                }
                continue;
            }
            RLSupplier[] args = new RLSupplier[func.getArity()];
            for (int i = 0; i < args.length; ++i) {
                args[args.length - i - 1] = (RLSupplier)this.stackAnswer.pop();
            }
            this.stackAnswer.push(func.getEval(args));
        }
        if (!valueArray && this.stackAnswer.size() > 1) {
            throw new QParseException("Missing or unknown operator:" + this.findNearesToken(this.stackAnswer));
        }
        return valueArray ? null : (RLSupplier)this.stackAnswer.pop();
    }

    private String findNearesToken(QStack stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            Object o = stack.get(i);
            if (o instanceof HasToken) {
                return ((HasToken)o).getErrorString();
            }
            try {
                Object val;
                boolean b = o instanceof RLSupplier;
                if (!b || !((val = ((RLSupplier)o).get()) instanceof HasToken)) continue;
                HasToken hasToken = (HasToken)val;
                return hasToken != null ? hasToken.getErrorString() : "null";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object[] getAnswerAsArray() {
        return this.stackAnswer.toArray();
    }
}

