/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.Subscriber;
import org.nustaq.reallive.server.StorageDriver;
import org.nustaq.reallive.server.storage.HeapRecordStorage;

public class SubscribedSet {
    RealLiveTable source;
    StorageDriver storage;
    Subscriber subs;

    public SubscribedSet(RealLiveTable source) {
        this(source, false);
    }

    public SubscribedSet(RealLiveTable source, boolean usConc) {
        this.source = source;
        this.storage = new StorageDriver(new HeapRecordStorage(usConc ? new ConcurrentHashMap() : new HashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(RLPredicate<Record> filter) {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            this.unsubscribe();
            this.subs = new Subscriber(filter, change -> {
                SubscribedSet subscribedSet = this;
                synchronized (subscribedSet) {
                    this.storage.receive(change);
                }
            });
            this.source.subscribe(this.subs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            if (this.subs != null) {
                this.source.unsubscribe(this.subs);
                this.subs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record get(String key) {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            return this.storage.getStore().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Record> cloneMap() {
        HashMap<Object, Record> res = new HashMap<Object, Record>();
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            this.storage.getStore().stream().forEach(rec -> res.put(rec.getKey(), (Record)rec));
        }
        return res;
    }

    public Map<Object, Record> getMap() {
        return ((HeapRecordStorage)this.storage.getStore()).getMap();
    }
}

