/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.server.actors.RealLiveTableActor;
import org.nustaq.reallive.server.storage.CachedOffHeapStorage;
import org.nustaq.reallive.server.storage.HeapRecordStorage;
import org.nustaq.reallive.server.storage.OffHeapRecordStorage;

public class EmbeddedRealLive {
    private static EmbeddedRealLive instance = new EmbeddedRealLive();
    public static Map<String, Function<TableDescription, RecordStorage>> sCustomRecordStorage = new HashMap<String, Function<TableDescription, RecordStorage>>();

    public static EmbeddedRealLive get() {
        return instance;
    }

    public IPromise<RealLiveTable> createTable(TableDescription desc, String dataDir) {
        Function<TableDescription, RecordStorage> memFactory;
        RealLiveTableActor table = (RealLiveTableActor)Actors.AsActor(RealLiveTableActor.class);
        if (desc.getFilePath() == null) {
            Log.Info((Object)this, (String)("no file specified. all data in memory " + desc.getName()));
            switch (desc.getStorageType()) {
                case "CACHED": {
                    memFactory = d -> new CachedOffHeapStorage(new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                case "PERSIST": {
                    memFactory = d -> new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case "TEMP": {
                    memFactory = d -> new HeapRecordStorage();
                    break;
                }
                default: {
                    memFactory = sCustomRecordStorage.get(desc.getStorageType());
                    if (memFactory == null) {
                        Log.Error((Object)this, (String)("unknown storage type " + desc.getStorageType() + " default to PERSIST"));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            String bp = dataDir == null ? desc.getFilePath() : dataDir;
            desc.filePath(bp);
            new File(bp).mkdirs();
            String file = desc.getStorageFile();
            switch (desc.getStorageType()) {
                case "CACHED": {
                    Log.Info((Object)this, (String)("memory mapping file " + file));
                    memFactory = d -> new CachedOffHeapStorage(new OffHeapRecordStorage(file, desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                case "PERSIST": {
                    Log.Info((Object)this, (String)("memory mapping file " + file));
                    memFactory = d -> new OffHeapRecordStorage(file, desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case "TEMP": {
                    memFactory = d -> new HeapRecordStorage();
                    break;
                }
                default: {
                    memFactory = sCustomRecordStorage.get(desc.getStorageType());
                    if (memFactory != null) break;
                    Log.Error((Object)this, (String)("unknown storage type " + desc.getStorageType() + " default to PERSIST"));
                }
            }
        }
        Promise p = new Promise();
        table.init(memFactory, desc).then((Callback & Serializable)(r, e) -> {
            if (e == null) {
                p.resolve((Object)table);
            } else {
                p.reject(e);
            }
        });
        return p;
    }
}

