/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.util.List;
import java.util.function.Supplier;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.api.TableState;
import org.nustaq.reallive.client.ShardedTable;
import org.nustaq.reallive.server.actors.RealLiveTableActor;
import org.nustaq.reallive.server.dynamic.DynClusterTableDistribution;

public class DynShardedTable
extends ShardedTable {
    private final Supplier<DynClusterTableDistribution> tableDistributionSupplier;

    public DynShardedTable(RealLiveTable[] shards, TableDescription desc, Supplier<DynClusterTableDistribution> tableDistributionSupplier) {
        super(shards, desc);
        this.tableDistributionSupplier = tableDistributionSupplier;
    }

    @Override
    protected RealLiveTable getTableForKey(String key) {
        List<TableState> states = this.tableDistributionSupplier.get().getStates();
        int h = key.hashCode();
        for (int i = 0; i < states.size(); ++i) {
            TableState tableState = states.get(i);
            if (!tableState.getMapping().matches(h)) continue;
            RealLiveTableActor associatedShard = tableState.getAssociatedTableShard();
            if (associatedShard == null) {
                for (RealLiveTableActor next : this.shards) {
                    if (!next.__clientSideTag.equals(tableState.getAssociatedShardName())) continue;
                    tableState.associatedTableShard(next);
                    return next;
                }
            }
            return associatedShard;
        }
        return null;
    }
}

