/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import java.io.Serializable;
import java.util.BitSet;
import org.nustaq.reallive.server.actors.RealLiveTableActor;
import org.nustaq.reallive.server.storage.ClusterTableRecordMapping;

public class TableState
implements Serializable {
    transient RealLiveTableActor associatedTableShard;
    String associatedShardName;
    String tableName;
    ClusterTableRecordMapping mapping;
    long numElements;

    public TableState(ClusterTableRecordMapping mapping, long numElements, String name) {
        this.mapping = mapping;
        this.numElements = numElements;
        this.tableName = name;
    }

    public RealLiveTableActor getAssociatedTableShard() {
        return this.associatedTableShard;
    }

    public ClusterTableRecordMapping getMapping() {
        return this.mapping;
    }

    public int getNumBuckets() {
        return this.getMapping().getBitset().cardinality();
    }

    public long getNumElements() {
        return this.numElements;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableState associatedTableShard(RealLiveTableActor assiatedShard) {
        this.associatedTableShard = assiatedShard;
        return this;
    }

    public TableState associatedShardName(String name) {
        this.associatedShardName = name;
        return this;
    }

    public String getAssociatedShardName() {
        return this.associatedShardName;
    }

    public TableState mapping(ClusterTableRecordMapping mapping) {
        this.mapping = mapping;
        return this;
    }

    public TableState numElements(long numElements) {
        this.numElements = numElements;
        return this;
    }

    public TableState tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String toString() {
        return "TableState{tableName='" + this.tableName + "', mapping=" + this.mapping + ", numElements=" + this.numElements + ", assShardName=" + this.associatedShardName + "}";
    }

    public boolean containsBucket(int i) {
        return this.mapping.getBitset().get(i);
    }

    public void addBuckets(int[] transfer) {
        this.getMapping().addBuckets(transfer);
    }

    public int[] takeBuckets(int transfer) {
        int[] res = new int[transfer];
        BitSet bitset = this.getMapping().getBitset();
        int bitPos = 0;
        int emptyCount = 0;
        for (int i = 0; i < res.length; ++i) {
            res[i] = bitset.nextSetBit(bitPos);
            if (res[i] < 0) {
                ++emptyCount;
                continue;
            }
            bitPos = res[i];
            bitset.set(bitPos, false);
        }
        if (emptyCount > 0) {
            int[] newRes = new int[res.length - emptyCount];
            for (int i = 0; i < newRes.length; ++i) {
                newRes[i] = res[i];
            }
            return newRes;
        }
        return res;
    }
}

