/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import java.io.Serializable;

public class TableDescription
implements Serializable,
Cloneable {
    public static final String TEMP = "TEMP";
    public static final String PERSIST = "PERSIST";
    public static final String CACHED = "CACHED";
    String name;
    int sizeMB = 100;
    String filePath = "USE_BASE_DIR";
    int numEntries = 100000;
    int shardNo;
    String shardId;
    int keyLen = 48;
    String storageType = "CACHED";
    String[] hashIndexed = new String[0];
    transient String alternativePath;

    public TableDescription() {
    }

    public TableDescription(String name) {
        this.name = name;
    }

    public TableDescription name(String name) {
        this.name = name;
        return this;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String[] getHashIndexed() {
        return this.hashIndexed;
    }

    public TableDescription storageType(String st) {
        this.storageType = st.toString();
        return this;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public TableDescription sizeMB(int sizeMB) {
        this.sizeMB = sizeMB;
        return this;
    }

    public TableDescription filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public TableDescription numEntries(int numEntries) {
        this.numEntries = numEntries;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeMB() {
        return this.sizeMB;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getShardNo() {
        return this.shardNo;
    }

    public TableDescription shardNo(int shardNo) {
        this.shardNo = shardNo;
        return this;
    }

    public TableDescription keyLen(int keyLen) {
        this.keyLen = keyLen;
        return this;
    }

    public int getKeyLen() {
        if (this.keyLen <= 8) {
            throw new RuntimeException("keylen too short");
        }
        return this.keyLen;
    }

    public TableDescription clone() {
        try {
            return (TableDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TableDescription shardId(String shardId) {
        this.shardId = shardId;
        return this;
    }

    public String getFileModifier() {
        return "" + this.shardNo;
    }

    public String getStorageFile() {
        if (this.alternativePath != null) {
            return this.getAlternativePath();
        }
        return this.getFilePath() + "/" + this.getName() + "_" + this.getFileModifier() + ".bin";
    }

    public String getAlternativePath() {
        return this.alternativePath;
    }

    public TableDescription alternativePath(String alternativePath) {
        this.alternativePath = alternativePath;
        return this;
    }
}

