/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.WriterConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.records.MapRecord;
import org.nustaq.reallive.server.storage.RecordJsonifier;

public interface Record
extends Serializable,
EvalContext {
    public static final String _NULL_ = "_NULL_";

    public static Record from(Object ... keyVals) {
        MapRecord aNew = MapRecord.New(null);
        for (int i = 0; i < keyVals.length; i += 2) {
            String key = (String)keyVals[i];
            Object val = keyVals[i + 1];
            if (key.equals("key")) {
                aNew.key((String)val);
                continue;
            }
            if (val == null) {
                val = _NULL_;
            }
            aNew.internal_put(key, val);
        }
        return aNew;
    }

    public static Object transform(Object val) {
        if (val instanceof Map) {
            return Record.from((Map)val);
        }
        if (val instanceof Collection) {
            return ((Collection)val).toArray(new Object[((Collection)val).size()]);
        }
        return val;
    }

    public static Record from(JsonObject jsonObject) {
        return RecordJsonifier.get().toRecord(jsonObject);
    }

    public static Record from(Map<String, Object> map) {
        return RecordJsonifier.get().from(map);
    }

    public String getKey();

    public long getLastModified();

    public void internal_setLastModified(long var1);

    public void internal_incSequence();

    public long getSequence();

    public Record internal_put(String var1, Object var2);

    default public void internal_updateLastModified() {
        this.internal_setLastModified(System.currentTimeMillis());
        this.internal_incSequence();
    }

    public Record key(String var1);

    public String[] getFields();

    public Record put(String var1, Object var2);

    @Override
    default public Value getValue(String field) {
        if ("_key".equals(field)) {
            return new StringValue(this.getKey(), null);
        }
        if ("_lastModified".equals(field)) {
            return new LongValue(this.getLastModified(), null);
        }
        return EvalContext.super.getValue(field);
    }

    default public Object mget(Object ... path) {
        if (path.length == 0) {
            return this;
        }
        Object current = this;
        for (int i = 0; i < path.length; ++i) {
            Object index = path[i];
            if (index instanceof String) {
                if (current instanceof Record) {
                    current = current.get((String)index);
                    continue;
                }
                return null;
            }
            if (!(index instanceof Number)) continue;
            if (current instanceof Object[]) {
                current = ((Object[])current)[((Number)index).intValue()];
                continue;
            }
            return null;
        }
        return current;
    }

    default public Number mgetNum(Object ... path) {
        Object mget = this.mget(path);
        if (mget instanceof Number) {
            return (Number)mget;
        }
        return 0;
    }

    default public String mgetString(Object ... path) {
        Object mget = this.mget(path);
        if (mget == null) {
            return "";
        }
        return mget.toString();
    }

    default public int getInt(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    default public long getLong(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0L;
        }
        return ((Number)val).longValue();
    }

    default public List asList(String field) {
        Object val = this.get(field);
        if (val instanceof Object[]) {
            return new ArrayList<Object>(Arrays.asList((Object[])val));
        }
        return null;
    }

    default public Set asSet(String field) {
        Object val = this.get(field);
        if (val instanceof Object[]) {
            return new HashSet<Object>(Arrays.asList((Object[])val));
        }
        return null;
    }

    default public Record putTransforming(String field, Object value) {
        this.put(field, Record.transform(value));
        return this;
    }

    default public Record haveRec(String field) {
        Object val = this.get(field);
        if (val == null) {
            MapRecord aNew = MapRecord.New(null);
            this.put(field, aNew);
            return aNew;
        }
        return this.getRec(field);
    }

    default public Record getRec(String field) {
        Object val = this.get(field);
        if (val instanceof Record) {
            return (Record)val;
        }
        return null;
    }

    default public <T> List<T> getAsList(String field) {
        return this.asList(field);
    }

    default public double getDouble(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0.0;
        }
        return ((Number)val).doubleValue();
    }

    default public String getString(String field) {
        Object val = this.get(field);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    default public String getSafeString(String field) {
        Object val = this.get(field);
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    default public String asString() {
        String[] fields = this.getFields();
        String res = "[  *" + this.getKey() + "  ";
        for (int i = 0; i < fields.length; ++i) {
            String s = fields[i];
            res = res + s + "=" + this.get(s) + ", ";
        }
        return res + "]";
    }

    default public boolean getBool(String field) {
        Object val = this.get(field);
        if (!(val instanceof Boolean)) {
            return false;
        }
        return (Boolean)val;
    }

    default public Record reduced(String[] reducedFields) {
        MapRecord rec = MapRecord.New(this.getKey());
        for (int i = 0; i < reducedFields.length; ++i) {
            String reducedField = reducedFields[i];
            Object val = this.get(reducedField);
            if (val == null) continue;
            rec.put(reducedField, val);
        }
        return rec;
    }

    default public Record omit(String[] fieldsToOmit) {
        MapRecord rec = MapRecord.New(this.getKey());
        HashSet<String> toOmit = new HashSet<String>();
        for (int i = 0; i < fieldsToOmit.length; ++i) {
            toOmit.add(fieldsToOmit[i]);
        }
        String[] fields = rec.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object val;
            String field = fields[i];
            if (toOmit.contains(field) || (val = this.get(field)) == null) continue;
            rec.put(field, val);
        }
        return rec;
    }

    default public Record copied() {
        throw new RuntimeException("copy not implemented");
    }

    default public Object[] getKeyVals() {
        String[] fields = this.getFields();
        Object[] res = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            res[i * 2] = field;
            res[i * 2 + 1] = this.get(field);
        }
        return res;
    }

    default public Map<String, Object> asMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            res.put(field, this.get(field));
        }
        return res;
    }

    default public void merge(Record record) {
        String[] fields = record.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            this.put(field, record.get(field));
        }
    }

    default public Record getRecord() {
        return this;
    }

    default public void stripOps() {
        String[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (field.endsWith("?+")) {
                this.put(field.substring(0, field.length() - 2), this.get(field));
                this.put(field, null);
                continue;
            }
            if (!field.endsWith("+") && !field.endsWith("-")) continue;
            this.put(field.substring(0, field.length() - 1), this.get(field));
            this.put(field, null);
        }
    }

    default public Record deepMerge(Record record) {
        String[] fields = record.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String op = "";
            Object foreignValue = record.get(field);
            if (field.endsWith("?+")) {
                op = "?+";
                field = field.substring(0, field.length() - 2);
            } else if (field.endsWith("+")) {
                op = "+";
                field = field.substring(0, field.length() - 1);
            } else if (field.endsWith("-")) {
                op = "-";
                field = field.substring(0, field.length() - 1);
            }
            Object selfValue = this.get(field);
            if (selfValue == null) {
                if (foreignValue instanceof Record) {
                    this.put(field, Record.from(new Object[0]).deepMerge((Record)foreignValue));
                    continue;
                }
                this.put(field, foreignValue);
                continue;
            }
            if (selfValue instanceof Object[]) {
                this.handleArrayOp(field, op, foreignValue, (Object[])selfValue);
                continue;
            }
            if (selfValue instanceof Record) {
                if (op.length() == 0) {
                    this.put(field, foreignValue);
                    continue;
                }
                switch (op) {
                    case "-": {
                        throw new RuntimeException("inconsistent operator '" + op + " on type Record field " + field);
                    }
                    case "+": {
                        if (foreignValue instanceof Record) {
                            this.put(field, ((Record)selfValue).deepMerge((Record)foreignValue));
                            break;
                        }
                        throw new RuntimeException("inconsistent operator '" + op + " on type Record field " + field);
                    }
                    case "?+": {
                        throw new RuntimeException("inconsistent operator '" + op + "' field " + field);
                    }
                    default: {
                        throw new RuntimeException("unknown operator '" + op + "' on  type Record field " + field);
                    }
                }
                continue;
            }
            this.put(field, foreignValue);
        }
        return this;
    }

    private void handleArrayOp(String field, String op, Object foreignValue, Object[] selfValue) {
        if (op.length() > 0 && !(foreignValue instanceof Object[])) {
            foreignValue = new Object[]{foreignValue};
        }
        switch (op) {
            case "-": {
                break;
            }
            case "+": 
            case "?+": {
                Object[] foreignArr = foreignValue;
                Object[] selfArr = selfValue;
                ArrayList<Object> unmatched = new ArrayList<Object>();
                for (int jj = 0; jj < foreignArr.length; ++jj) {
                    Object toAdd = foreignArr[jj];
                    boolean matched = false;
                    if ("?+".equals(op)) {
                        for (int j = 0; j < selfArr.length; ++j) {
                            Object o1 = selfArr[j];
                            if (!Objects.deepEquals(o1, toAdd)) continue;
                            matched = true;
                            selfArr[j] = toAdd;
                            break;
                        }
                    }
                    if (matched) continue;
                    unmatched.add(toAdd);
                }
                if (unmatched.size() > 0) {
                    ArrayList<Object> objects = new ArrayList<Object>(Arrays.asList(selfArr));
                    objects.addAll(unmatched);
                    selfArr = objects.toArray();
                    this.put(field, selfArr);
                    break;
                }
                this.put(field, selfArr);
                break;
            }
            case "": {
                this.put(field, foreignValue);
                break;
            }
            default: {
                throw new RuntimeException("unknown operator '" + op + "'");
            }
        }
    }

    default public String toPrettyString() {
        return RecordJsonifier.get().fromRecord(this).toString(WriterConfig.PRETTY_PRINT);
    }

    default public JsonObject toJson() {
        return RecordJsonifier.get().fromRecord(this);
    }

    default public boolean validateForJsonability() {
        String[] fields = this.getFields();
        Class[] allowed = new Class[]{Number.class, Boolean.class, Object[].class, String.class};
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            Object val = this.get(field);
            if (val == null) continue;
            boolean valid = false;
            if (val instanceof Record) {
                valid = ((Record)val).validateForJsonability();
            } else {
                for (int j = 0; j < allowed.length; ++j) {
                    Class aClass = allowed[j];
                    if (!aClass.isAssignableFrom(val.getClass())) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    System.err.println("invalid attribute value:" + val.getClass().getName() + " in field " + field);
                }
            }
            if (valid) continue;
            return false;
        }
        return true;
    }
}

