/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.Spore;
import org.nustaq.kontraktor.annotations.CallerSideMethod;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.SafeRealLiveStreamActor;
import org.nustaq.reallive.query.QParseException;
import org.nustaq.reallive.server.FilterSpore;
import org.nustaq.reallive.server.MapSpore;
import org.nustaq.reallive.server.QueryPredicate;

public interface RealLiveStreamActor
extends SafeRealLiveStreamActor {
    public <T> void forEachWithSpore(Spore<Record, T> var1);

    @CallerSideMethod
    default public void forEach(RLPredicate<Record> predicate, Callback<Record> cb) {
        this.forEachWithSpore(new FilterSpore(predicate).setForEach(cb).onFinish(() -> cb.finish()));
    }

    @CallerSideMethod
    default public <R> void map(RLPredicate<Record> predicate, RLFunction<Record, R> mapFun, Callback<R> cb) {
        this.forEachWithSpore(new MapSpore(predicate, mapFun).setForEach(cb).onFinish(() -> cb.finish()));
    }

    @Override
    @CallerSideMethod
    default public void query(String query, Callback<Record> cb) throws QParseException {
        this.forEach(new QueryPredicate<Record>(query), cb);
    }

    @CallerSideMethod
    default public <O> void forEach(Spore<Record, O> spore, Callback<O> result) {
        spore.setForEach(result).onFinish(() -> result.complete(null, null));
        this.forEachWithSpore(spore);
    }
}

