/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.query.QToken;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.query.VarPath;
import org.nustaq.reallive.server.storage.HashIndex;

public class RLHashIndexPredicate
implements RLPredicate<Record> {
    List<RLPath> pathes = new ArrayList<RLPath>();
    RLPredicate subQuery;

    public static <T> RLHashIndexPredicate hashIndex(String path, Object key, RLPredicate<Record> subQuery) {
        return new RLHashIndexPredicate(path, key, subQuery);
    }

    public RLHashIndexPredicate(RLPredicate subQuery) {
        this.subQuery = subQuery;
    }

    public RLHashIndexPredicate(String path, Object key, RLPredicate subQuery) {
        this.join(path, key);
        this.subQuery = subQuery;
    }

    public RLHashIndexPredicate join(String path, Object key) {
        this.pathes.add(new JoinPath(path, key));
        return this;
    }

    public RLHashIndexPredicate subtract(String path, Object key) {
        this.pathes.add(new SubtractPath(path, key));
        return this;
    }

    public RLHashIndexPredicate intersect(String path, Object key) {
        this.pathes.add(new IntersectionPath(path, key));
        return this;
    }

    public RLHashIndexPredicate subQuery(RLPredicate sq) {
        this.subQuery = sq;
        return this;
    }

    @Override
    public boolean test(Record t) {
        boolean res = false;
        for (int i = 0; i < this.pathes.size(); ++i) {
            RLPath rlPath = this.pathes.get(i);
            Value evaluate = rlPath.varPath.evaluate(t);
            if (evaluate == null) {
                return false;
            }
            Object value = HashIndex.unifyKey(evaluate.getValue());
            if (rlPath instanceof JoinPath) {
                if (!rlPath.getKey().equals(value)) continue;
                res = true;
                continue;
            }
            if (rlPath instanceof SubtractPath) {
                if (!rlPath.getKey().equals(value)) continue;
                res = false;
                continue;
            }
            if (!(rlPath instanceof IntersectionPath) || !res || rlPath.getKey().equals(value)) continue;
            res = false;
        }
        return res && this.subQuery.test(t);
    }

    public List<RLPath> getPath() {
        return this.pathes;
    }

    public RLPath getPath(int i) {
        return this.pathes.get(i);
    }

    public String toString() {
        return "RLHashIndexPredicate{pathes=" + this.pathes + ", subQuery=" + this.subQuery + "}";
    }

    public static class JoinPath
    extends RLPath
    implements Serializable {
        public JoinPath(String path, Object key) {
            super(path, key);
        }
    }

    public static class SubtractPath
    extends RLPath
    implements Serializable {
        public SubtractPath(String path, Object key) {
            super(path, key);
        }
    }

    public static class IntersectionPath
    extends RLPath
    implements Serializable {
        public IntersectionPath(String path, Object key) {
            super(path, key);
        }
    }

    public static abstract class RLPath {
        String path;
        Object key;
        VarPath varPath;

        public RLPath(String path, Object key) {
            this.path = path;
            this.key = HashIndex.unifyKey(key);
            this.varPath = new VarPath(path, null, new QToken(path, "", 0));
        }

        public boolean test(Record r) {
            return this.key.equals(this.varPath.evaluate(r));
        }

        public Object getKey() {
            return this.key;
        }

        public String getPathString() {
            return this.path;
        }

        public String toString() {
            return "RLPath{path='" + this.path + "', key=" + this.key + "}";
        }
    }
}

