/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.io.Serializable;
import org.nustaq.reallive.query.ArrayValue;
import org.nustaq.reallive.query.DoubleValue;
import org.nustaq.reallive.query.HasToken;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.QToken;
import org.nustaq.reallive.query.StringValue;

public interface Value
extends Serializable,
HasToken {
    public static final Value TRUE = new LongValue(1L, null);
    public static final Value FALSE = new LongValue(0L, null);

    @Override
    public QToken getToken();

    public double getDoubleValue();

    public long getLongValue();

    public String getStringValue();

    default public Object[] getArrayValue() {
        return new Object[]{this.getValue()};
    }

    public Object getValue();

    default public boolean isDouble() {
        return this instanceof DoubleValue;
    }

    default public boolean isLong() {
        return this instanceof LongValue;
    }

    default public boolean isString() {
        return this instanceof StringValue;
    }

    default public boolean isArray() {
        return this instanceof ArrayValue;
    }

    default public boolean isTrue() {
        if (this.isString()) {
            String sv = this.getStringValue();
            return !"false".equals(sv) && sv.length() > 0 && !"0".equals(sv);
        }
        return this.getLongValue() != 0L;
    }

    public Value negate();

    public boolean isEmpty();
}

