/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import org.nustaq.reallive.query.Evaluator;
import org.nustaq.reallive.query.QStack;
import org.nustaq.reallive.query.QToken;
import org.nustaq.reallive.query.RLSupplier;
import org.nustaq.reallive.query.Value;

public class ArrayValue
implements Value {
    Object[] value;
    QToken token;

    public ArrayValue(Object[] value, QToken token) {
        this.value = value;
        this.token = token;
    }

    @Override
    public QToken getToken() {
        return this.token;
    }

    @Override
    public double getDoubleValue() {
        return this.value.length;
    }

    @Override
    public long getLongValue() {
        return this.value.length;
    }

    @Override
    public String getStringValue() {
        return "[array]";
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Value negate() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.length == 0;
    }

    public long size() {
        return this.value.length;
    }

    public RLSupplier getEval() {
        QStack stackRPN = new QStack();
        for (int i = 0; i < this.value.length; ++i) {
            stackRPN.add(this.value[i]);
        }
        Evaluator eval = new Evaluator(stackRPN);
        eval.evaluate(true);
        return () -> new ArrayValue(eval.getAnswerAsArray(), this.token);
    }
}

