/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.tablespace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.api.TableSpace;
import org.nustaq.reallive.impl.actors.ShardedTable;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.impl.tablespace.TableSpaceActor;
import org.nustaq.reallive.messages.StateMessage;

public class TableSpaceSharding
implements TableSpace {
    List<TableSpaceActor> shards = new ArrayList<TableSpaceActor>();
    HashMap<String, RealLiveTable> tableMap = new HashMap();
    HashMap<String, TableDescription> tableDescriptionMap = new HashMap();

    public TableSpaceSharding(TableSpaceActor[] shards) {
        Arrays.stream(shards).forEach(sh -> this.addShard((TableSpaceActor)sh));
    }

    private void addShard(TableSpaceActor sh) {
        if (this.shards.indexOf(sh) < 0) {
            this.shards.add(sh);
        } else {
            Log.Warn((Object)this, (String)("double add of shard " + sh));
        }
    }

    public IPromise init() {
        return new Promise((Object)"done");
    }

    @Override
    public IPromise<RealLiveTable> createOrLoadTable(TableDescription desc) {
        Promise res = new Promise();
        ArrayList<Promise> results = new ArrayList<Promise>();
        int i = 0;
        while (i < this.shards.size()) {
            TableSpaceActor shard = this.shards.get(i);
            IPromise<RealLiveTable> table = shard.createOrLoadTable(desc.clone().shardNo(i));
            Promise p = new Promise();
            results.add(p);
            int finalI = i++;
            table.then((Callback & Serializable)(r, e) -> {
                if (e == null) {
                    Log.Info((Object)this, (String)("table creation: " + desc.getName() + " " + finalI));
                } else if (e instanceof Throwable) {
                    Log.Info((Object)this, (Throwable)((Throwable)e), (String)("failed table creation: " + desc.getName() + " " + finalI));
                } else {
                    Log.Info((Object)this, (String)("failed table creation: " + desc.getName() + " " + finalI + " " + e));
                }
                p.complete(r, e);
            });
        }
        Log.Info((Object)this, (String)"waiting for creation of tables ..");
        Actors.all(results).then((Callback & Serializable)(tables, err) -> {
            Log.Info((Object)this, (String)"table creation (waiting finished)");
            RealLiveTable[] tableShards = new RealLiveTable[tables.size()];
            boolean errors = false;
            for (int i = 0; i < tables.size(); ++i) {
                if (((IPromise)tables.get(i)).get() == null) {
                    res.reject(((IPromise)tables.get(i)).getError());
                    errors = true;
                    break;
                }
                int sno = i;
                if (tableShards[sno] != null) {
                    res.reject((Object)("shard " + sno + " is present more than once"));
                    errors = true;
                    break;
                }
                tableShards[sno] = (RealLiveTable)((IPromise)tables.get(i)).get();
            }
            if (!errors) {
                ShardedTable ts = new ShardedTable(tableShards, desc);
                this.tableMap.put(desc.getName(), ts);
                this.tableDescriptionMap.put(desc.getName(), desc);
                res.resolve((Object)ts);
            }
        });
        return res;
    }

    @Override
    public IPromise dropTable(String name) {
        ArrayList<IPromise> results = new ArrayList<IPromise>();
        for (int i = 0; i < this.shards.size(); ++i) {
            TableSpaceActor shard = this.shards.get(i);
            results.add(shard.dropTable(name));
        }
        return Actors.all(results);
    }

    @Override
    public IPromise<List<TableDescription>> getTableDescriptions() {
        List collect = this.tableMap.values().stream().map(ts -> ts.getDescription()).collect(Collectors.toList());
        return Actors.allMapped(collect);
    }

    public List<StorageStats> getStats() {
        return this.tableMap.keySet().stream().map(tableName -> ((StorageStats)this.tableMap.get(tableName).getStats().await()).tableName((String)tableName)).collect(Collectors.toList());
    }

    @Override
    public IPromise<List<RealLiveTable>> getTables() {
        return new Promise(new ArrayList<RealLiveTable>(this.tableMap.values()));
    }

    @Override
    public IPromise<RealLiveTable> getTableAsync(String name) {
        return Actors.resolve((Object)this.tableMap.get(name));
    }

    @Override
    public IPromise shutDown() {
        return new Promise((Object)"void");
    }

    @Override
    public void stateListener(Callback<StateMessage> stateListener) {
        throw new RuntimeException("unimplemented");
    }
}

