/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.impl.StorageDriver;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.impl.storage.OffHeapRecordStorage;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.records.MapRecord;

public class CachedOffHeapStorage
implements RecordStorage {
    OffHeapRecordStorage offheap;
    HeapRecordStorage onHeap;

    public CachedOffHeapStorage(OffHeapRecordStorage offheap, final HeapRecordStorage onHeap) {
        this.offheap = offheap;
        this.onHeap = onHeap;
        final ArrayList reput = new ArrayList();
        offheap.forEachWithSpore(new Spore<Record, Object>(){

            public void remote(Record input) {
                Record unwrap = StorageDriver.unwrap(input);
                if (unwrap != input) {
                    reput.add(unwrap);
                }
                if (unwrap.getClass() != MapRecord.recordClass && MapRecord.conversion != null) {
                    unwrap = MapRecord.conversion.apply((MapRecord)unwrap);
                    reput.add(unwrap);
                }
                onHeap._put(input.getKey(), unwrap);
            }
        });
        for (int i = 0; i < reput.size(); ++i) {
            Record record = (Record)reput.get(i);
            offheap.put(record.getKey(), record);
        }
    }

    @Override
    public RecordStorage put(String key, Record value) {
        value.internal_updateLastModified();
        this.offheap._put(key, value);
        this.onHeap._put(key, value);
        return this;
    }

    @Override
    public Record get(String key) {
        return this.onHeap.get(key);
    }

    @Override
    public Record remove(String key) {
        Record res = this.offheap.remove(key);
        this.onHeap.remove(key);
        return res;
    }

    @Override
    public long size() {
        return this.onHeap.size();
    }

    @Override
    public StorageStats getStats() {
        return this.offheap.getStats();
    }

    @Override
    public Stream<Record> stream() {
        return this.onHeap.stream();
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrowBytes) {
        this.offheap.resizeIfLoadFactorLarger(loadFactor, maxGrowBytes);
    }

    @Override
    public <T> void forEachWithSpore(Spore<Record, T> spore) {
        this.onHeap.forEachWithSpore(spore);
    }
}

