/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.util.HashMap;
import org.nustaq.reallive.query.ArrayValue;
import org.nustaq.reallive.query.CompiledQuery;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.FuncOperand;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.NumberValue;
import org.nustaq.reallive.query.Operator;
import org.nustaq.reallive.query.Parser;
import org.nustaq.reallive.query.QParseException;
import org.nustaq.reallive.query.RLSupplier;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;

public class Query {
    public static synchronized CompiledQuery compile(String query) {
        return Query.newParser().compile(query);
    }

    public static Value eval(String query, EvalContext ctx) {
        return Query.newParser().compile(query).evaluate(ctx);
    }

    protected static Parser newParser() {
        HashMap<String, FuncOperand> functions = new HashMap<String, FuncOperand>();
        Query.defaultFun(functions);
        HashMap<String, Operator> operators = new HashMap<String, Operator>();
        Query.defaultOps(operators);
        return new Parser(functions, operators);
    }

    protected static void defaultOps(HashMap<String, Operator> operators) {
        operators.put("!", new Operator("!", 15, 1){

            @Override
            protected Value compare(Value vb, Value va) {
                return new LongValue(vb.isTrue() ? 0L : 1L, null);
            }
        });
        operators.put("+", new Operator("+", 7){

            @Override
            protected Value compare(Value vb, Value va) {
                if (va == null) {
                    return vb.negate();
                }
                return super.compare(vb, va);
            }

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue + longValue1;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue + doubleValue1;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue + stringValue1;
            }
        });
        operators.put("-", new Operator("-", 7){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue - longValue1;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue - doubleValue1;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                if (stringValue.endsWith(stringValue1)) {
                    return stringValue.substring(0, stringValue.lastIndexOf(stringValue1));
                }
                return stringValue;
            }
        });
        operators.put("*", new Operator("*"){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue * longValue1;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue * doubleValue1;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue + "*" + stringValue;
            }
        });
        operators.put("/", new Operator("/"){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue / longValue1;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue / doubleValue1;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.replace(stringValue1, "");
            }
        });
        operators.put("**", new Operator("**", 6){

            @Override
            protected Value compare(Value vb, Value va) {
                if (va.isArray()) {
                    Object bval = vb.getValue();
                    Value bvalue = vb;
                    Value avalue = va;
                    return this.compareArray(bval, bvalue, avalue);
                }
                if (vb.isArray()) {
                    Object bval = va.getValue();
                    Value bvalue = va;
                    Value avalue = vb;
                    return this.compareArray(bval, bvalue, avalue);
                }
                return va.getStringValue().toLowerCase().indexOf(vb.getStringValue().toLowerCase()) >= 0 ? Value.TRUE : Value.FALSE;
            }

            private Value compareArray(Object bval, Value bvalue, Value avalue) {
                Object[] ov = (Object[])avalue.getValue();
                for (int i = 0; i < ov.length; ++i) {
                    Object o = ov[i];
                    if (o instanceof RLSupplier) {
                        o = ((RLSupplier)o).get();
                    }
                    if (o instanceof Number && bvalue instanceof NumberValue) {
                        if (((Number)o).doubleValue() != bvalue.getDoubleValue()) continue;
                        return Value.TRUE;
                    }
                    if (o instanceof NumberValue && bvalue instanceof NumberValue) {
                        if (((Value)o).getDoubleValue() != bvalue.getDoubleValue()) continue;
                        return Value.TRUE;
                    }
                    if (o instanceof Value) {
                        o = ((Value)o).getStringValue();
                    }
                    if (o == null || !o.toString().equals(bval.toString())) continue;
                    return Value.TRUE;
                }
                return Value.FALSE;
            }
        });
        operators.put("*>", new Operator("*>", 6){

            @Override
            protected Value compare(Value vb, Value va) {
                return va.getStringValue().toLowerCase().endsWith(vb.getStringValue().toLowerCase()) ? Value.TRUE : Value.FALSE;
            }
        });
        operators.put("<*", new Operator("<*", 6){

            @Override
            protected Value compare(Value vb, Value va) {
                return va.getStringValue().toLowerCase().startsWith(vb.getStringValue().toLowerCase()) ? Value.TRUE : Value.FALSE;
            }
        });
        operators.put("==", new Operator("==", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue == longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue == doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.equals(stringValue1) ? "1" : "0";
            }
        });
        operators.put("&&", new Operator("&&", 3){

            @Override
            public RLSupplier<Value> getEval(RLSupplier<Value> arg, RLSupplier<Value> arg1) {
                return () -> {
                    Value va = (Value)arg1.get();
                    if (!va.isTrue()) {
                        return Value.FALSE;
                    }
                    Value vb = (Value)arg.get();
                    return this.compare(vb, va);
                };
            }

            @Override
            protected Value compare(Value vb, Value va) {
                return vb.isTrue() && va.isTrue() ? Value.TRUE : Value.FALSE;
            }
        });
        operators.put("||", new Operator("||", 3){

            @Override
            public RLSupplier<Value> getEval(RLSupplier<Value> arg, RLSupplier<Value> arg1) {
                return () -> {
                    Value va = (Value)arg1.get();
                    if (va.isTrue()) {
                        return Value.TRUE;
                    }
                    Value vb = (Value)arg.get();
                    return this.compare(vb, va);
                };
            }

            @Override
            protected Value compare(Value vb, Value va) {
                return vb.isTrue() || va.isTrue() ? Value.TRUE : Value.FALSE;
            }
        });
        operators.put("^", new Operator("^", 3){

            @Override
            protected Value compare(Value vb, Value va) {
                return vb.isTrue() ^ va.isTrue() ? Value.TRUE : Value.FALSE;
            }
        });
        operators.put("<", new Operator("<", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue < longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue < doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.compareTo(stringValue1) < 0 ? "1" : "";
            }
        });
        operators.put("<=", new Operator("<=", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue <= longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue <= doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.compareTo(stringValue1) <= 0 ? "1" : "";
            }
        });
        operators.put(">", new Operator(">", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue > longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue > doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.compareTo(stringValue1) > 0 ? "1" : "";
            }
        });
        operators.put(">=", new Operator(">=", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue >= longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue >= doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.compareTo(stringValue1) >= 0 ? "1" : "";
            }
        });
        operators.put("!=", new Operator("!=", 6){

            @Override
            protected long longOp(long longValue, long longValue1) {
                return longValue != longValue1 ? 1L : 0L;
            }

            @Override
            protected double doubleOp(double doubleValue, double doubleValue1) {
                return doubleValue != doubleValue1 ? 1.0 : 0.0;
            }

            @Override
            protected String stringOp(String stringValue, String stringValue1) {
                return stringValue.compareTo(stringValue1) != 0 ? "1" : "";
            }
        });
    }

    protected static void defaultFun(HashMap<String, FuncOperand> functions) {
        functions.put("lower", new FuncOperand("lower", 1){

            @Override
            protected Value apply(RLSupplier<Value>[] args) {
                return new StringValue(((Value)args[0].get()).getStringValue().toLowerCase(), null);
            }
        });
        functions.put("upper", new FuncOperand("upper", 1){

            @Override
            protected Value apply(RLSupplier<Value>[] args) {
                return new StringValue(((Value)args[0].get()).getStringValue().toUpperCase(), null);
            }
        });
        functions.put("exists", new FuncOperand("exists", 1){

            @Override
            protected Value apply(RLSupplier<Value>[] args) {
                Value value = (Value)args[0].get();
                return value.isEmpty() ? Value.FALSE : Value.TRUE;
            }
        });
        functions.put("isEmpty", new FuncOperand("isEmpty", 1){

            @Override
            protected Value apply(RLSupplier<Value>[] args) {
                Value value = (Value)args[0].get();
                return value.isEmpty() ? Value.TRUE : Value.FALSE;
            }
        });
        functions.put("length", new FuncOperand("length", 1){

            @Override
            protected Value apply(RLSupplier<Value>[] args) {
                Value value = (Value)args[0].get();
                if (value.isArray()) {
                    return new LongValue(((ArrayValue)value).size(), null);
                }
                return new LongValue(0L, null);
            }
        });
        functions.put("age", new FuncOperand("age", 2){
            final long minute = 60000L;
            final long hour = 3600000L;
            final long day = 86400000L;
            final long week = 604800000L;
            final long month = 2592000000L;
            final long year = 31536000000L;

            @Override
            public RLSupplier<Value> getEval(final RLSupplier<Value>[] args) {
                if (args.length != this.arity) {
                    String err = args.length > 0 ? ((Value)args[args.length - 1].get()).getErrorString() : " - ";
                    throw new QParseException("invalid number of arguments:" + this.name + " " + err);
                }
                return new RLSupplier<Value>(){
                    long now = System.currentTimeMillis();

                    @Override
                    public Value get() {
                        return this.apply(args, this.now);
                    }
                };
            }

            protected Value apply(RLSupplier<Value>[] args, long now) {
                String sv;
                long val = ((Value)args[0].get()).getLongValue();
                switch (sv = ((Value)args[1].get()).getStringValue()) {
                    case "ms": {
                        val = now - val * 1L;
                        break;
                    }
                    case "sec": {
                        val = now - val * 1000L;
                        break;
                    }
                    case "min": {
                        val = now - val * 60000L;
                        break;
                    }
                    case "hour": {
                        val = now - val * 3600000L;
                        break;
                    }
                    case "day": {
                        val = now - val * 86400000L;
                        break;
                    }
                    case "week": {
                        val = now - val * 604800000L;
                        break;
                    }
                    case "month": {
                        val = now - val * 2592000000L;
                        break;
                    }
                    case "year": {
                        val = now - val * 31536000000L;
                        break;
                    }
                    default: {
                        throw new QParseException("invalid arg in age(..):" + sv + ", " + ((Value)args[1].get()).getErrorString());
                    }
                }
                return new LongValue(val, ((Value)args[0].get()).getToken());
            }
        });
        functions.put("now", new FuncOperand("now", 0){

            @Override
            public RLSupplier<Value> getEval(final RLSupplier<Value>[] args) {
                if (args.length != this.arity) {
                    String err = args.length > 0 ? ((Value)args[args.length - 1].get()).getErrorString() : " - ";
                    throw new QParseException("invalid number of arguments:" + this.name + ", " + err);
                }
                return new RLSupplier<Value>(){
                    long now = System.currentTimeMillis();

                    @Override
                    public Value get() {
                        return this.apply(args, this.now);
                    }
                };
            }

            protected Value apply(RLSupplier<Value>[] args, long now) {
                return new LongValue(now, null);
            }
        });
    }
}

