/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.nustaq.reallive.query.ArrayValue;
import org.nustaq.reallive.query.BooleanValue;
import org.nustaq.reallive.query.CompiledQuery;
import org.nustaq.reallive.query.DoubleValue;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.Evaluator;
import org.nustaq.reallive.query.FuncOperand;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.Operator;
import org.nustaq.reallive.query.QScanner;
import org.nustaq.reallive.query.QStack;
import org.nustaq.reallive.query.QToken;
import org.nustaq.reallive.query.Query;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.query.VarPath;
import org.nustaq.reallive.records.MapRecord;

public class Parser {
    HashMap<String, FuncOperand> functions;
    HashMap<String, Operator> operators;
    private final String SEPARATOR = ",";
    private QStack stackOperations = new QStack();
    private QStack stackRPN = new QStack();
    private QStack stackAnswer = new QStack();
    protected EvalContext[] ctxRef;

    Parser(HashMap<String, FuncOperand> functions, HashMap<String, Operator> operators) {
        this.functions = functions;
        this.operators = operators;
    }

    public CompiledQuery compile(String query) {
        this.ctxRef = new EvalContext[1];
        this.parse(query);
        return new CompiledQuery(new Evaluator(this.stackRPN).evaluate(), this.ctxRef);
    }

    protected void parse(String expression) {
        QToken token;
        this.stackOperations.clear();
        this.stackRPN.clear();
        QScanner scanner = new QScanner(expression);
        QToken prevToken = null;
        while ((token = scanner.readNext()) != null) {
            String tokenValue = token.getValue();
            if (this.isSeparator(tokenValue)) {
                if (this.stackOperations.empty() || !this.isOpenEckig(this.stackOperations.lastElement().toString())) {
                    while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement().toString())) {
                        this.stackRPN.push(this.stackOperations.pop());
                    }
                }
            } else if (this.isOpenEckig(tokenValue)) {
                this.stackRPN.push(tokenValue);
                this.stackOperations.push(tokenValue);
            } else if (this.isCloseEckig(tokenValue)) {
                while (!this.stackOperations.empty() && !this.isOpenEckig(this.stackOperations.lastElement().toString())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                while (!this.stackRPN.empty() && !this.isOpenEckig(this.stackRPN.lastElement().toString())) {
                    arr.add(this.stackRPN.pop());
                }
                this.stackRPN.pop();
                this.stackOperations.pop();
                this.stackRPN.push(new ArrayValue(arr.toArray(), token));
            } else if (this.isOpenBracket(tokenValue)) {
                Object last;
                Object object = last = this.stackRPN.isEmpty() ? null : this.stackRPN.lastElement();
                if (last instanceof VarPath && this.isFunction(((VarPath)last).field)) {
                    this.stackRPN.pop();
                    this.stackOperations.push(this.functions.get(((VarPath)last).field));
                }
                this.stackOperations.push(token);
            } else if (this.isCloseBracket(tokenValue)) {
                while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement().toString())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.pop();
                if (!this.stackOperations.empty() && this.stackOperations.lastElement() instanceof FuncOperand) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
            } else if (this.isNumber(tokenValue)) {
                if (tokenValue.indexOf(46) < 0) {
                    Long i = Long.parseLong(tokenValue);
                    this.stackRPN.push(new LongValue(i, token));
                } else {
                    Double d = Double.parseDouble(tokenValue);
                    this.stackRPN.push(new DoubleValue(d, token));
                }
            } else if (this.operators.containsKey(tokenValue)) {
                Operator op = this.operators.get(tokenValue);
                boolean prefix = false;
                if ((tokenValue.equals("+") || tokenValue.equals("-")) && (prevToken == null || this.operators.containsKey(prevToken.getValue()) || this.isOpenBracket(prevToken.getValue()) || this.isOpenEckig(prevToken.getValue()) || this.isSeparator(prevToken.getValue()))) {
                    prefix = true;
                    this.stackRPN.push(new LongValue(0L, token));
                }
                while (!this.stackOperations.empty() && !prefix && this.stackOperations.lastElement() instanceof Operator && op.getPrecedence() <= ((Operator)this.stackOperations.lastElement()).getPrecedence()) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.push(op);
            } else if (tokenValue.startsWith("'") && tokenValue.endsWith("'")) {
                this.stackRPN.push(new StringValue(tokenValue.substring(1, tokenValue.length() - 1), token));
            } else if (tokenValue.startsWith("\"") && tokenValue.endsWith("\"")) {
                this.stackRPN.push(new StringValue(tokenValue.substring(1, tokenValue.length() - 1), token));
            } else if ("true".equals(tokenValue)) {
                this.stackRPN.push(new BooleanValue(true, token));
            } else if ("false".equals(tokenValue)) {
                this.stackRPN.push(new BooleanValue(false, token));
            } else {
                this.stackRPN.push(new VarPath(tokenValue, this.ctxRef, token));
            }
            prevToken = token;
        }
        while (!this.stackOperations.empty()) {
            this.stackRPN.push(this.stackOperations.pop());
        }
        Collections.reverse(this.stackRPN);
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isFunction(String token) {
        return this.functions.containsKey(token);
    }

    private boolean isSeparator(String token) {
        return token.equals(",");
    }

    private boolean isOpenBracket(String token) {
        return "(".equals(token);
    }

    private boolean isCloseBracket(String token) {
        return token.equals(")");
    }

    private boolean isOpenEckig(String token) {
        return "[".equals(token);
    }

    private boolean isCloseEckig(String token) {
        return token.equals("]");
    }

    public static void main(String[] args) throws Throwable {
        Parser p = Query.newParser();
        MapRecord hm = MapRecord.New("key").put("test", "hallo").put("a", 100).put("arr", new Object[]{100, "hallo", 3}).put("c", -1).put("time", System.currentTimeMillis()).put("b", 200);
        Parser.testArray(p, hm);
        Thread.sleep(2000L);
        CompiledQuery nums = Query.compile("c!= -1");
        System.out.println(nums.evaluate(hm));
        CompiledQuery ctrue = Query.compile("time < age(1,'sec')");
        CompiledQuery cfalse = Query.compile("time < age(5,'sec')");
        CompiledQuery tim = Query.compile("a<1000000000");
        CompiledQuery trUe = Query.compile("1");
        System.out.println(ctrue.evaluate(hm));
        System.out.println(cfalse.evaluate(hm));
        System.out.println(tim.evaluate(hm));
        System.out.println(trUe.evaluate(hm).isTrue());
    }

    protected static void testArray(Parser p, MapRecord hm) {
        CompiledQuery compile = p.compile("'hallo' ** [1,2,'ha'+'llo']");
        Value evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,50+50]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,100]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("a ** [1,2,a]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("100 ** [1,2,a]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo' ** [1,2,test]");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo' ** arr");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("1 ** arr");
        evaluate = compile.evaluate(hm);
        if (evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("3 ** arr");
        evaluate = compile.evaluate(hm);
        if (!evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        compile = p.compile("'hallo1' ** arr");
        evaluate = compile.evaluate(hm);
        if (evaluate.isTrue()) {
            throw new RuntimeException("test failure");
        }
        System.out.println("testArray success");
    }
}

