/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl;

import java.io.Serializable;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.ChangeMessage;
import org.nustaq.reallive.api.ChangeReceiver;
import org.nustaq.reallive.api.RLFunction;
import org.nustaq.reallive.api.RLPredicate;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.impl.RLUtil;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.ChangeUtils;
import org.nustaq.reallive.messages.Diff;
import org.nustaq.reallive.messages.PutMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.records.PatchingRecord;
import org.nustaq.reallive.records.RecordWrapper;

public class StorageDriver
implements ChangeReceiver {
    RecordStorage store;
    ChangeReceiver listener;

    public StorageDriver(RecordStorage store) {
        this.listener = change -> {};
        this.store = store;
        Log.Info((Object)this, (String)("" + store.getStats()));
    }

    public StorageDriver() {
        this.listener = change -> {};
    }

    public static Record unwrap(Record r) {
        if (r instanceof PatchingRecord) {
            return StorageDriver.unwrap(((PatchingRecord)r).unwrapOrCopy());
        }
        if (r instanceof RecordWrapper) {
            return StorageDriver.unwrap(((RecordWrapper)r).getRecord());
        }
        return r;
    }

    @Override
    public void receive(ChangeMessage change) {
        switch (change.getType()) {
            case 3: {
                break;
            }
            case 4: {
                Record prevRecord = this.store.get(change.getKey());
                if (prevRecord == null) {
                    this.store.put(change.getKey(), StorageDriver.unwrap(change.getRecord()));
                    this.receive(new AddMessage(change.getSenderId(), true, change.getRecord()));
                    break;
                }
                Diff diff = ChangeUtils.diff(change.getRecord(), prevRecord);
                if (diff.isEmpty()) break;
                Record newRecord = StorageDriver.unwrap(change.getRecord());
                this.store.put(change.getKey(), newRecord);
                this.listener.receive(new UpdateMessage(change.getSenderId(), diff, newRecord, null));
                break;
            }
            case 0: {
                AddMessage addMessage = (AddMessage)change;
                String key = addMessage.getKey();
                Record prevRecord = this.store.get(key);
                if (prevRecord != null && !addMessage.isUpdateIfExisting()) {
                    return;
                }
                if (prevRecord != null) {
                    Diff diff = ChangeUtils.copyAndDiff(addMessage.getRecord(), prevRecord);
                    Record newRecord = StorageDriver.unwrap(prevRecord);
                    this.store.put(change.getKey(), newRecord);
                    this.listener.receive(new UpdateMessage(change.getSenderId(), diff, newRecord, null));
                    break;
                }
                this.store.put(change.getKey(), StorageDriver.unwrap(addMessage.getRecord()));
                this.listener.receive(addMessage);
                break;
            }
            case 1: {
                RemoveMessage removeMessage = (RemoveMessage)change;
                Record v = this.store.remove(removeMessage.getKey());
                if (v == null) break;
                this.listener.receive(new RemoveMessage(change.getSenderId(), StorageDriver.unwrap(v)));
                break;
            }
            case 2: {
                UpdateMessage updateMessage = (UpdateMessage)change;
                Record oldRec = this.store.get(updateMessage.getKey());
                if (oldRec == null && updateMessage.isAddIfNotExists()) {
                    if (updateMessage.getNewRecord() == null) {
                        throw new RuntimeException("updated record does not exist, cannot fall back to 'Add' as UpdateMessage.newRecord is null");
                    }
                    this.store.put(change.getKey(), updateMessage.getNewRecord());
                    this.listener.receive(new AddMessage(change.getSenderId(), updateMessage.getNewRecord()));
                    break;
                }
                if (updateMessage.getDiff() == null) {
                    Diff diff = ChangeUtils.copyAndDiff(updateMessage.getNewRecord(), oldRec);
                    if (diff.isEmpty()) break;
                    Record newRecord = StorageDriver.unwrap(oldRec);
                    this.store.put(change.getKey(), newRecord);
                    this.listener.receive(new UpdateMessage(change.getSenderId(), diff, newRecord, change.getForcedUpdateFields()));
                    break;
                }
                if (updateMessage.getDiff().isEmpty()) break;
                Diff newDiff = ChangeUtils.copyAndDiff(updateMessage.getNewRecord(), oldRec, updateMessage.getDiff().getChangedFields());
                Record newRecord = StorageDriver.unwrap(oldRec);
                this.store.put(change.getKey(), newRecord);
                this.listener.receive(new UpdateMessage(change.getSenderId(), newDiff, newRecord, change.getForcedUpdateFields()));
                break;
            }
            default: {
                throw new RuntimeException("unknown change type " + change.getType());
            }
        }
    }

    public RecordStorage getStore() {
        return this.store;
    }

    public ChangeReceiver getListener() {
        return this.listener;
    }

    public StorageDriver store(RecordStorage store) {
        this.store = store;
        return this;
    }

    public StorageDriver setListener(ChangeReceiver listener) {
        this.listener = listener;
        return this;
    }

    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrowBytes) {
        this.store.resizeIfLoadFactorLarger(loadFactor, maxGrowBytes);
    }

    public void put(int senderId, String key, Object ... keyVals) {
        this.receive(RLUtil.get().put(senderId, key, keyVals));
    }

    public IPromise atomicQuery(String key, RLFunction<Record, Object> action) {
        Record rec = this.getStore().get(key);
        if (rec == null) {
            Object apply = action.apply(rec);
            if (apply instanceof ChangeMessage) {
                this.receive((ChangeMessage)apply);
            }
            return new Promise(apply);
        }
        PatchingRecord pr = new PatchingRecord(rec);
        Object res = action.apply(pr);
        if (res instanceof ChangeMessage) {
            this.receive((ChangeMessage)res);
        } else {
            UpdateMessage updates = pr.getUpdates(0);
            if (updates != null) {
                this.receive(updates);
            }
        }
        return new Promise(res);
    }

    public void atomicUpdate(RLPredicate<Record> filter, RLFunction<Record, Boolean> action) {
        this.store.forEach(filter, (Callback<Record>)(Callback & Serializable)(r, e) -> {
            if (r != null) {
                PatchingRecord pr = new PatchingRecord((Record)r);
                Boolean res = (Boolean)action.apply(pr);
                if (res == Boolean.FALSE) {
                    this.receive(RLUtil.get().remove(0, pr.getKey()));
                } else {
                    UpdateMessage updates = pr.getUpdates(0);
                    if (updates != null) {
                        this.receive(updates);
                    }
                }
            }
        });
    }

    public void addOrUpdate(int senderId, String key, Object ... keyVals) {
        this.receive(RLUtil.get().addOrUpdate(senderId, key, keyVals));
    }

    public void add(int senderId, String key, Object ... keyVals) {
        this.receive(RLUtil.get().add(senderId, key, keyVals));
    }

    public void add(int senderId, Record rec) {
        this.receive(new AddMessage(senderId, rec));
    }

    public void addOrUpdateRec(int senderId, Record rec) {
        this.receive(new AddMessage(senderId, true, rec));
    }

    public void put(int senderId, Record rec) {
        this.receive(new PutMessage(senderId, rec));
    }

    public void update(int senderId, String key, Object ... keyVals) {
        this.receive(RLUtil.get().update(senderId, key, keyVals));
    }

    public void remove(int senderId, String key) {
        RemoveMessage remove = RLUtil.get().remove(senderId, key);
        this.receive(remove);
    }
}

