/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl;

import java.util.ArrayList;
import java.util.List;
import org.nustaq.reallive.api.ChangeMessage;
import org.nustaq.reallive.api.ChangeReceiver;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.Subscriber;
import org.nustaq.reallive.impl.FilterSpore;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.PutMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.records.PatchingRecord;

public class FilterProcessor
implements ChangeReceiver {
    List<Subscriber> filterList = new ArrayList<Subscriber>();
    RealLiveTable table;

    public FilterProcessor(RealLiveTable table) {
        this.table = table;
    }

    public synchronized void startListening(Subscriber subs) {
        this.filterList.add(subs);
    }

    public synchronized void unsubscribe(Subscriber subs) {
        this.filterList.remove(subs);
    }

    @Override
    public synchronized void receive(ChangeMessage change) {
        switch (change.getType()) {
            case 3: {
                break;
            }
            case 4: {
                this.processPut((PutMessage)change);
                break;
            }
            case 0: {
                this.processAdd((AddMessage)change);
                break;
            }
            case 2: {
                this.processUpdate((UpdateMessage)change);
                break;
            }
            case 1: {
                this.processRemove((RemoveMessage)change);
            }
        }
    }

    protected void processPut(PutMessage change) {
        Record record = change.getRecord();
        for (Subscriber subscriber : this.filterList) {
            if (!subscriber.getFilter().test(record)) continue;
            subscriber.getReceiver().receive(change);
        }
    }

    protected void processUpdate(UpdateMessage change) {
        Record newRecord = change.getNewRecord();
        String[] changedFields = change.getDiff().getChangedFields();
        Object[] oldValues = change.getDiff().getOldValues();
        Record oldRec = new PatchingRecord(newRecord);
        for (int i = 0; i < changedFields.length; ++i) {
            String changedField = changedFields[i];
            oldRec.put(changedField, oldValues[i]);
        }
        for (Subscriber subscriber : this.filterList) {
            PatchingRecord patchingRecord;
            boolean matchesOld = subscriber.getFilter().test(oldRec);
            boolean matchesNew = subscriber.getFilter().test(newRecord);
            if (matchesNew) {
                patchingRecord = FilterSpore.rec.get();
                patchingRecord.reset(newRecord);
                matchesNew = subscriber.getFilter().test(newRecord);
                newRecord = patchingRecord.unwrapOrCopy();
            }
            if (matchesOld) {
                patchingRecord = FilterSpore.rec.get();
                patchingRecord.reset(oldRec);
                matchesOld = subscriber.getFilter().test(oldRec);
                oldRec = patchingRecord.unwrapOrCopy();
            }
            if (matchesOld && matchesNew) {
                subscriber.getReceiver().receive(change);
                continue;
            }
            if (matchesOld) {
                subscriber.getReceiver().receive(new RemoveMessage(change.getSenderId(), newRecord));
                continue;
            }
            if (!matchesNew) continue;
            subscriber.getReceiver().receive(new AddMessage(change.getSenderId(), newRecord));
        }
    }

    protected void processAdd(AddMessage add) {
        Record record = add.getRecord();
        for (Subscriber subscriber : this.filterList) {
            if (!subscriber.getFilter().test(record)) continue;
            PatchingRecord patchingRecord = FilterSpore.rec.get();
            patchingRecord.reset(record);
            if (!subscriber.getFilter().test(patchingRecord)) continue;
            subscriber.getReceiver().receive(new AddMessage(add.getSenderId(), add.isUpdateIfExisting(), patchingRecord.unwrapOrCopy()));
        }
    }

    protected void processRemove(RemoveMessage remove) {
        Record record = remove.getRecord();
        for (Subscriber subscriber : this.filterList) {
            if (!subscriber.getFilter().test(record)) continue;
            PatchingRecord patchingRecord = FilterSpore.rec.get();
            patchingRecord.reset(record);
            if (!subscriber.getFilter().test(patchingRecord)) continue;
            subscriber.getReceiver().receive(remove);
        }
    }

    public void unsubscribeById(long subsId) {
        ArrayList<Subscriber> toRem = new ArrayList<Subscriber>();
        for (Subscriber subscriber : this.filterList) {
            if ((long)subscriber.getId() != subsId) continue;
            toRem.add(subscriber);
        }
        toRem.forEach(s -> this.unsubscribe((Subscriber)s));
    }
}

