/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.io.File;
import java.util.function.Supplier;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.impl.actors.RealLiveTableActor;
import org.nustaq.reallive.impl.storage.CachedOffHeapStorage;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.impl.storage.OffHeapRecordStorage;

public class EmbeddedRealLive {
    private static EmbeddedRealLive instance = new EmbeddedRealLive();

    public static EmbeddedRealLive get() {
        return instance;
    }

    public IPromise<RealLiveTable> createTable(TableDescription desc, String dataDir) {
        Supplier<RecordStorage> memFactory;
        RealLiveTableActor table = (RealLiveTableActor)Actors.AsActor(RealLiveTableActor.class);
        if (desc.getFilePath() == null) {
            Log.Info((Object)this, (String)("no file specified. all data in memory " + desc.getName()));
            switch (desc.getStorageType()) {
                case CACHED: {
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                default: {
                    Log.Error((Object)this, (String)("unknown storage type " + (Object)((Object)desc.getStorageType()) + " default to PERSIST"));
                }
                case PERSIST: {
                    memFactory = () -> new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                    break;
                }
            }
        } else {
            String bp = dataDir == null ? desc.getFilePath() : dataDir;
            desc.filePath(bp);
            new File(bp).mkdirs();
            String file = bp + "/" + desc.getName() + "_" + desc.getShardNo() + ".bin";
            switch (desc.getStorageType()) {
                case CACHED: {
                    Log.Info((Object)this, (String)("memory mapping file " + file));
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(file, desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                default: {
                    Log.Error((Object)this, (String)("unknown storage type " + (Object)((Object)desc.getStorageType()) + " default to PERSIST"));
                }
                case PERSIST: {
                    Log.Info((Object)this, (String)("memory mapping file " + file));
                    memFactory = () -> new OffHeapRecordStorage(file, desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                }
            }
        }
        table.init(memFactory, desc).await(30000L);
        return new Promise((Object)table);
    }
}

