/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.impl.storage.StorageStats;

public class HeapRecordStorage
implements RecordStorage {
    Map<Object, Record> map;

    public HeapRecordStorage() {
        this.map = new HashMap<Object, Record>();
    }

    public HeapRecordStorage(Map<Object, Record> map) {
        this.map = map;
    }

    @Override
    public RecordStorage put(String key, Record value) {
        value.updateLastModified();
        return this._put(key, value);
    }

    public RecordStorage _put(String key, Record value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Record get(String key) {
        return this.map.get(key);
    }

    @Override
    public Record remove(String key) {
        return this.map.remove(key);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public <T> void forEachWithSpore(Spore<Record, T> spore) {
        long now = System.currentTimeMillis();
        for (Map.Entry<Object, Record> next : this.map.entrySet()) {
            spore.remote((Object)next.getValue());
            if (!spore.isFinished()) continue;
            break;
        }
        spore.finish();
    }

    public Map<Object, Record> getMap() {
        return this.map;
    }

    @Override
    public StorageStats getStats() {
        StorageStats stats = new StorageStats().capacity(-1L).freeMem(-1L).usedMem(-1L).numElems(this.map.size());
        return stats;
    }

    @Override
    public Stream<Record> stream() {
        return this.map.entrySet().stream().map(en -> (Record)en.getValue());
    }

    @Override
    public void resizeIfLoadFactorLarger(double loadFactor, long maxGrowBytes) {
    }
}

