/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.records.MapRecord;

public interface Record
extends Serializable,
EvalContext {
    public String getKey();

    public long getLastModified();

    public void setLastModified(long var1);

    default public void updateLastModified() {
        this.setLastModified(System.currentTimeMillis());
    }

    public void key(String var1);

    public String[] getFields();

    public Record put(String var1, Object var2);

    @Override
    default public Value getValue(String field) {
        if ("_key".equals(field)) {
            return new StringValue(this.getKey().toString());
        }
        return EvalContext.super.getValue(field);
    }

    default public int getInt(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    default public long getLong(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0L;
        }
        return ((Number)val).longValue();
    }

    default public Record getRec(String field) {
        Object val = this.get(field);
        if (val == null) {
            return MapRecord.New(null);
        }
        return (Record)val;
    }

    default public Record rec(String field) {
        Object val = this.get(field);
        if (val == null) {
            MapRecord aNew = MapRecord.New(null);
            this.put(field, aNew);
            return aNew;
        }
        return (Record)val;
    }

    default public List arr(String field) {
        Object val = this.get(field);
        if (val == null) {
            ArrayList aNew = new ArrayList();
            this.put(field, aNew);
            return aNew;
        }
        return (List)val;
    }

    default public List<Record> recarr(String field) {
        Object val = this.get(field);
        if (val == null) {
            ArrayList<Record> aNew = new ArrayList<Record>();
            this.put(field, aNew);
            return aNew;
        }
        return (List)val;
    }

    default public double getDouble(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0.0;
        }
        return ((Number)val).doubleValue();
    }

    default public String getString(String field) {
        Object val = this.get(field);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    default public String asString() {
        String[] fields = this.getFields();
        String res = "[  *" + this.getKey() + "  ";
        for (int i = 0; i < fields.length; ++i) {
            String s = fields[i];
            res = res + s + "=" + this.get(s) + ", ";
        }
        return res + "]";
    }

    default public boolean getBool(String field) {
        Object val = this.get(field);
        if (!(val instanceof Boolean)) {
            return false;
        }
        return (Boolean)val;
    }

    default public Record reduced(String[] reducedFields) {
        MapRecord rec = MapRecord.New(this.getKey());
        for (int i = 0; i < reducedFields.length; ++i) {
            String reducedField = reducedFields[i];
            Object val = this.get(reducedField);
            if (val == null) continue;
            rec.put(reducedField, val);
        }
        return rec;
    }

    default public Record copied() {
        throw new RuntimeException("copy not implemented");
    }

    default public Object[] getKeyVals() {
        String[] fields = this.getFields();
        Object[] res = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            res[i * 2] = field;
            res[i * 2 + 1] = this.get(field);
        }
        return res;
    }
}

