/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.records;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.nustaq.reallive.api.Record;
import org.nustaq.reallive.impl.RLUtil;

public class MapRecord
implements Record {
    public static boolean CHECK_TYPES = true;
    public static Class<? extends MapRecord> recordClass = MapRecord.class;
    public static Function<MapRecord, MapRecord> conversion;
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected transient String[] fields;
    protected String key;

    static MapRecord New() {
        try {
            return recordClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected MapRecord() {
    }

    public static MapRecord New(String key) {
        MapRecord mapRecord = MapRecord.New();
        mapRecord.key = key;
        return mapRecord;
    }

    public static MapRecord New(String key, Object ... values) {
        MapRecord mapRecord = MapRecord.New(key);
        RLUtil.get().buildRecord(mapRecord, values);
        return mapRecord;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void key(String key) {
        this.key = key;
    }

    @Override
    public String[] getFields() {
        if (this.fields == null) {
            this.fields = new String[this.map.size()];
            this.map.keySet().toArray(this.fields);
        }
        return this.fields;
    }

    @Override
    public Object get(String field) {
        return this.map.get(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MapRecord put(String key, Object value) {
        if (this.map.put(key, value) == null) {
            this.fields = null;
        }
        if (value == null) {
            this.map.remove(key);
            return this;
        } else if (CHECK_TYPES) {
            Class<?> clazz = value.getClass();
            String name = clazz.getName();
            if (!this.isSimpleType(name) && (!clazz.isArray() || !clazz.getComponentType().isPrimitive() && !this.isSimpleType(clazz.getComponentType().getName()))) throw new RuntimeException("allowed values: jdk classes and instanceof Record");
            this.map.put(key, value);
            return this;
        } else {
            this.map.put(key, value);
        }
        return this;
    }

    private boolean isSimpleType(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.equals(MapRecord.class.getName());
    }

    public String toString() {
        return "MapRecord{" + this.asString() + '}';
    }

    @Override
    public MapRecord copied() {
        MapRecord newReq = MapRecord.New(this.getKey());
        this.map.forEach((k, v) -> newReq.put((String)k, v));
        return newReq;
    }
}

