/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StorageStats
implements Serializable {
    String name = "none";
    long usedMem;
    long freeMem;
    long capacity;
    int numElems;
    List<StorageStats> subStats;
    String tableName;

    public StorageStats name(String name) {
        this.name = name;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public StorageStats tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public StorageStats usedMem(long usedMem) {
        this.usedMem = usedMem;
        return this;
    }

    public StorageStats freeMem(long freeMem) {
        this.freeMem = freeMem;
        return this;
    }

    public StorageStats capacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public StorageStats numElems(int numElems) {
        this.numElems = numElems;
        return this;
    }

    public long getUsedMem() {
        return this.usedMem;
    }

    public long getFreeMem() {
        return this.freeMem;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public int getNumElems() {
        return this.numElems;
    }

    public String getName() {
        return this.name;
    }

    public void addTo(StorageStats storageStats) {
        storageStats.capacity += this.capacity;
        storageStats.numElems += this.numElems;
        storageStats.freeMem += this.freeMem;
        storageStats.usedMem += this.usedMem;
        storageStats.name = this.name;
        storageStats.addSubstats(this);
    }

    private void addSubstats(StorageStats storageStats) {
        if (this.subStats == null) {
            this.subStats = new ArrayList<StorageStats>();
        }
        this.subStats.add(storageStats);
    }

    public List<StorageStats> getSubStats() {
        return this.subStats;
    }

    public String toString() {
        return "StorageStats{name='" + this.name + '\'' + ", usedMem=" + this.usedMem / 0x100000L + " MB, freeMem=" + this.freeMem / 0x100000L + " MB, capacity=" + this.capacity + " MB, numElems=" + this.numElems + ", subStats=" + this.subStats + '}';
    }

    public String toStringLean() {
        return "name='" + this.name + '\'' + ", usedMem=" + this.usedMem / 0x100000L + " MB, freeMem=" + this.freeMem / 0x100000L + " MB, capacity=" + this.capacity + " MB, numElems=" + this.numElems + "";
    }
}

