/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.io.File;
import java.util.function.Supplier;
import org.nustaq.kontraktor.Actors;
import org.nustaq.reallive.api.RealLiveTable;
import org.nustaq.reallive.api.RecordStorage;
import org.nustaq.reallive.api.TableDescription;
import org.nustaq.reallive.impl.actors.RealLiveTableActor;
import org.nustaq.reallive.impl.storage.CachedOffHeapStorage;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.impl.storage.OffHeapRecordStorage;

public class EmbeddedRealLive {
    private static EmbeddedRealLive instance = new EmbeddedRealLive();

    public static EmbeddedRealLive get() {
        return instance;
    }

    public RealLiveTable createTable(TableDescription desc, String dataDir) {
        Supplier<RecordStorage> memFactory;
        RealLiveTableActor table = (RealLiveTableActor)Actors.AsActor(RealLiveTableActor.class);
        if (desc.getFilePath() == null) {
            switch (desc.getType()) {
                case CACHED: {
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                default: {
                    memFactory = () -> new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                    break;
                }
            }
        } else {
            String bp = dataDir == null ? desc.getFilePath() : dataDir;
            desc.filePath(bp);
            new File(bp).mkdirs();
            switch (desc.getType()) {
                case CACHED: {
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(bp + "/" + desc.getName() + "_" + desc.getShardNo() + ".bin", desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage());
                    break;
                }
                default: {
                    memFactory = () -> new OffHeapRecordStorage(bp + "/" + desc.getName() + "_" + desc.getShardNo() + ".bin", desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                }
            }
        }
        table.init(memFactory, desc).await();
        return table;
    }
}

