/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl;

import java.util.Objects;
import java.util.Set;
import org.nustaq.reallive.interfaces.ChangeMessage;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.Diff;
import org.nustaq.reallive.messages.PutMessage;
import org.nustaq.reallive.messages.QueryDoneMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.records.MapRecord;

public class RLUtil {
    static RLUtil instance = new RLUtil();

    public static RLUtil get() {
        return instance;
    }

    public <K> AddMessage<K> add(K key, Object ... keyVals) {
        Record<K> record = this.record(key, keyVals);
        return new AddMessage<K>(record);
    }

    public <K> PutMessage<K> put(K key, Object ... keyVals) {
        Record<K> record = this.record(key, keyVals);
        return new PutMessage<K>(record);
    }

    public <K> AddMessage<K> addOrUpdate(K key, Object ... keyVals) {
        Record<K> record = this.record(key, keyVals);
        return new AddMessage<K>(true, record);
    }

    public <K> UpdateMessage<K> updateWithForced(K key, Set<String> forced, Object ... keyVals) {
        UpdateMessage<K> update = this.update(key, keyVals);
        update.setForcedUpdateFields(forced);
        return update;
    }

    public <K> UpdateMessage<K> update(K key, Object ... keyVals) {
        String[] fi = new String[keyVals.length / 2];
        for (int i = 0; i < fi.length; ++i) {
            fi[i] = (String)keyVals[i * 2];
        }
        Diff d = new Diff(fi, null);
        Record<K> record = this.record(key, keyVals);
        return new UpdateMessage<K>(d, record, null);
    }

    public <K> Record<K> record(K key, Object ... keyVals) {
        MapRecord<K> res = MapRecord.New(key);
        return this.buildRecord(res, keyVals);
    }

    public <K> Record<K> buildRecord(Record<K> res, Object[] keyVals) {
        for (int i = 0; i < keyVals.length; i += 2) {
            Object k = keyVals[i];
            Object v = keyVals[i + 1];
            res.put((String)k, v);
        }
        return res;
    }

    public <K> RemoveMessage<K> remove(K key) {
        return new RemoveMessage<K>(MapRecord.New(key));
    }

    public <K> ChangeMessage<K> done() {
        return new QueryDoneMessage();
    }

    public boolean isEqual(Record rlRec, Record copy) {
        String[] fields = rlRec.getFields();
        if (fields.length != copy.getFields().length) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            Object b;
            String field = fields[i];
            Object a = rlRec.get(field);
            if (Objects.deepEquals(a, b = copy.get(field))) continue;
            return false;
        }
        return true;
    }
}

