/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.messages;

import java.util.Set;
import org.nustaq.reallive.interfaces.ChangeMessage;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.messages.Diff;

public class UpdateMessage<K>
implements ChangeMessage<K> {
    final Diff diff;
    final Record<K> newRecord;
    final boolean addIfNotExists;
    Set<String> forcedUpdateFields;

    public UpdateMessage(Diff diff, Record<K> newRecord, Set<String> forcedUpdateFields) {
        this.diff = diff;
        this.newRecord = newRecord;
        this.addIfNotExists = true;
        this.forcedUpdateFields = forcedUpdateFields;
    }

    public UpdateMessage(Diff diff, Record<K> newRecord, Set<String> forcedUpdateFields, boolean addIfNotExists) {
        this.addIfNotExists = addIfNotExists;
        this.newRecord = newRecord;
        this.diff = diff;
        this.forcedUpdateFields = forcedUpdateFields;
    }

    @Override
    public Set<String> getForcedUpdateFields() {
        return this.forcedUpdateFields;
    }

    public void setForcedUpdateFields(Set<String> forcedUpdateFields) {
        this.forcedUpdateFields = forcedUpdateFields;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public K getKey() {
        return this.newRecord.getKey();
    }

    @Override
    public ChangeMessage reduced(String[] reducedFields) {
        return new UpdateMessage<K>(this.diff.reduced(reducedFields), this.newRecord.reduced(reducedFields), this.forcedUpdateFields, this.addIfNotExists);
    }

    public Diff getDiff() {
        return this.diff;
    }

    public Record<K> getNewRecord() {
        return this.newRecord;
    }

    public boolean isAddIfNotExists() {
        return this.addIfNotExists;
    }

    public String toString() {
        return "UpdateMessage{diff=" + this.diff + ", newRecord=" + this.newRecord.asString() + ", addIfNotExists=" + this.addIfNotExists + '}';
    }
}

