/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.impl.StorageDriver;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.impl.storage.OffHeapRecordStorage;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.RecordStorage;
import org.nustaq.reallive.records.MapRecord;

public class CachedOffHeapStorage
implements RecordStorage<String> {
    OffHeapRecordStorage offheap;
    HeapRecordStorage<String> onHeap;

    public CachedOffHeapStorage(OffHeapRecordStorage offheap, final HeapRecordStorage<String> onHeap) {
        this.offheap = offheap;
        this.onHeap = onHeap;
        final ArrayList reput = new ArrayList();
        offheap.forEach(new Spore<Record<String>, Object>(){

            public void remote(Record<String> input) {
                Record unwrap = StorageDriver.unwrap(input);
                if (unwrap != input) {
                    reput.add(unwrap);
                }
                if (unwrap.getClass() != MapRecord.recordClass && MapRecord.conversion != null) {
                    unwrap = MapRecord.conversion.apply((MapRecord)unwrap);
                    reput.add(unwrap);
                }
                onHeap.put(input.getKey(), unwrap);
            }
        });
        for (int i = 0; i < reput.size(); ++i) {
            Record record = (Record)reput.get(i);
            offheap.put((String)record.getKey(), (Record<String>)record);
        }
    }

    @Override
    public RecordStorage put(String key, Record<String> value) {
        this.offheap.put(key, value);
        this.onHeap.put(key, value);
        return this;
    }

    @Override
    public Record<String> get(String key) {
        return this.onHeap.get(key);
    }

    @Override
    public Record<String> remove(String key) {
        Record<String> res = this.offheap.remove(key);
        this.onHeap.remove(key);
        return res;
    }

    @Override
    public long size() {
        return this.onHeap.size();
    }

    @Override
    public StorageStats getStats() {
        return this.offheap.getStats();
    }

    @Override
    public Stream<Record<String>> stream() {
        return this.onHeap.stream();
    }

    @Override
    public <T> void forEach(Spore<Record<String>, T> spore) {
        this.onHeap.forEach(spore);
    }
}

