/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl;

import java.util.ArrayList;
import java.util.List;
import org.nustaq.reallive.impl.FilterSpore;
import org.nustaq.reallive.impl.actors.RealLiveTableActor;
import org.nustaq.reallive.interfaces.ChangeMessage;
import org.nustaq.reallive.interfaces.ChangeReceiver;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.Subscriber;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.ChangeUtils;
import org.nustaq.reallive.messages.PutMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;
import org.nustaq.reallive.records.PatchingRecord;
import org.nustaq.reallive.records.RecordWrapper;

public class FilterProcessor<K>
implements ChangeReceiver<K> {
    List<Subscriber<K>> filterList = new ArrayList<Subscriber<K>>();
    RealLiveTableActor<K> table;

    public FilterProcessor(RealLiveTableActor<K> table) {
        this.table = table;
    }

    public void startListening(Subscriber<K> subs) {
        this.filterList.add(subs);
    }

    public void unsubscribe(Subscriber<K> subs) {
        this.filterList.remove(subs);
    }

    @Override
    public void receive(ChangeMessage<K> change) {
        switch (change.getType()) {
            case 3: {
                break;
            }
            case 4: {
                this.processPut((PutMessage)change);
                break;
            }
            case 0: {
                this.processAdd((AddMessage)change);
                break;
            }
            case 2: {
                this.processUpdate((UpdateMessage)change);
                break;
            }
            case 1: {
                this.processRemove((RemoveMessage)change);
            }
        }
    }

    protected void processPut(PutMessage<K> change) {
        Record<K> record = change.getRecord();
        for (Subscriber<K> subscriber : this.filterList) {
            if (!subscriber.getFilter().test(record)) continue;
            subscriber.getReceiver().receive(change);
        }
    }

    protected void processUpdate(UpdateMessage<K> change) {
        Record<K> newRecord = change.getNewRecord();
        final String[] changedFields = change.getDiff().getChangedFields();
        final Object[] oldValues = change.getDiff().getOldValues();
        Record oldRec = new RecordWrapper(newRecord){

            @Override
            public Object get(String field) {
                int index = ChangeUtils.indexOf(field, changedFields);
                if (index >= 0) {
                    return oldValues[index];
                }
                return super.get(field);
            }
        };
        for (Subscriber<K> subscriber : this.filterList) {
            PatchingRecord patchingRecord;
            boolean matchesOld = subscriber.getPrePatchFilter().test(oldRec);
            boolean matchesNew = subscriber.getPrePatchFilter().test(newRecord);
            if (matchesNew) {
                patchingRecord = FilterSpore.rec.get();
                patchingRecord.reset(newRecord);
                matchesNew = subscriber.getFilter().test(newRecord);
                newRecord = patchingRecord.unwrapOrCopy();
            }
            if (matchesOld) {
                patchingRecord = FilterSpore.rec.get();
                patchingRecord.reset(oldRec);
                matchesOld = subscriber.getFilter().test(oldRec);
                oldRec = patchingRecord.unwrapOrCopy();
            }
            if (matchesOld && matchesNew) {
                subscriber.getReceiver().receive(change);
                continue;
            }
            if (matchesOld) {
                subscriber.getReceiver().receive(new RemoveMessage<K>(newRecord));
                continue;
            }
            if (!matchesNew) continue;
            subscriber.getReceiver().receive(new AddMessage<K>(newRecord));
        }
    }

    protected void processAdd(AddMessage<K> add) {
        Record<K> record = add.getRecord();
        for (Subscriber<K> subscriber : this.filterList) {
            if (!subscriber.getPrePatchFilter().test(record)) continue;
            PatchingRecord patchingRecord = FilterSpore.rec.get();
            patchingRecord.reset(record);
            if (!subscriber.getFilter().test(patchingRecord)) continue;
            subscriber.getReceiver().receive(new AddMessage(add.isUpdateIfExisting(), patchingRecord.unwrapOrCopy()));
        }
    }

    protected void processRemove(RemoveMessage remove) {
        Record record = remove.getRecord();
        for (Subscriber<K> subscriber : this.filterList) {
            if (!subscriber.getPrePatchFilter().test(record)) continue;
            PatchingRecord patchingRecord = FilterSpore.rec.get();
            patchingRecord.reset(record);
            if (!subscriber.getFilter().test(patchingRecord)) continue;
            subscriber.getReceiver().receive(remove);
        }
    }
}

