/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nustaq.kontraktor.Spore;
import org.nustaq.offheap.FSTAsciiStringOffheapMap;
import org.nustaq.offheap.FSTSerializedOffheapMap;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.RecordStorage;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.simpleapi.DefaultCoder;
import org.nustaq.serialization.simpleapi.FSTCoder;
import org.nustaq.serialization.util.FSTUtil;

public class OffHeapRecordStorage
implements RecordStorage<String> {
    private static final boolean DEBUG = false;
    OutputStream protocol;
    FSTCoder coder;
    FSTSerializedOffheapMap<String, Record<String>> store;
    int keyLen;
    Thread _t;

    protected OffHeapRecordStorage() {
    }

    public OffHeapRecordStorage(int maxKeyLen, int sizeMB, int estimatedNumRecords) {
        this.keyLen = maxKeyLen;
        this.init(null, sizeMB, estimatedNumRecords, maxKeyLen, false, Record.class);
    }

    public OffHeapRecordStorage(String file, int maxKeyLen, int sizeMB, int estimatedNumRecords) {
        this.keyLen = maxKeyLen;
        this.init(file, sizeMB, estimatedNumRecords, maxKeyLen, true, Record.class);
    }

    protected void init(String tableFile, int sizeMB, int estimatedNumRecords, int keyLen, boolean persist, Class ... toReg) {
        this.keyLen = keyLen;
        this.coder = new DefaultCoder();
        if (toReg != null) {
            this.coder.getConf().registerClass(toReg);
        }
        if (persist) {
            try {
                this.store = this.createPersistentMap(tableFile, sizeMB, estimatedNumRecords, keyLen);
            }
            catch (Exception e) {
                FSTUtil.rethrow((Throwable)e);
            }
        } else {
            this.store = this.createMemMap(sizeMB, estimatedNumRecords, keyLen);
        }
    }

    protected FSTSerializedOffheapMap<String, Record<String>> createMemMap(int sizeMB, int estimatedNumRecords, int keyLen) {
        return new FSTAsciiStringOffheapMap(keyLen, 0x100000L * (long)sizeMB, estimatedNumRecords, this.coder);
    }

    protected FSTSerializedOffheapMap<String, Record<String>> createPersistentMap(String tableFile, int sizeMB, int estimatedNumRecords, int keyLen) throws Exception {
        return new FSTAsciiStringOffheapMap(tableFile, keyLen, 0x100000L * (long)sizeMB, estimatedNumRecords, this.coder);
    }

    @Override
    public StorageStats getStats() {
        StorageStats stats = new StorageStats().name(this.store.getFileName()).capacity(this.store.getCapacityMB()).freeMem(this.store.getFreeMem()).usedMem(this.store.getUsedMem()).numElems(this.store.getSize());
        return stats;
    }

    @Override
    public RecordStorage put(String key, Record<String> value) {
        if (this.protocol != null) {
            try {
                FSTConfiguration.getDefaultConfiguration().encodeToStream(this.protocol, (Object)new Object[]{"put", key, value});
                this.protocol.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.store.put((Object)key, value);
        return this;
    }

    void checkThread() {
        if (this._t == null) {
            this._t = Thread.currentThread();
        } else if (this._t != Thread.currentThread()) {
            throw new RuntimeException("Unexpected MultiThreading");
        }
    }

    @Override
    public Record<String> get(String key) {
        this.checkThread();
        return (Record)this.store.get((Object)key);
    }

    @Override
    public Record<String> remove(String key) {
        Record<String> v;
        if (this.protocol != null) {
            try {
                FSTConfiguration.getDefaultConfiguration().encodeToStream(this.protocol, (Object)new Object[]{"remove", key});
                this.protocol.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((v = this.get(key)) != null) {
            this.store.remove((Object)key);
        }
        return v;
    }

    @Override
    public long size() {
        return this.store.getSize();
    }

    @Override
    public Stream<Record<String>> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.store.values(), 1024), false);
    }

    @Override
    public <T> void forEach(Spore<Record<String>, T> spore) {
        Iterator iterator = this.store.values();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            spore.remote((Object)record);
            if (!spore.isFinished()) continue;
            break;
        }
        spore.finish();
    }
}

