/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.RecordStorage;

public class HeapRecordStorage<K>
implements RecordStorage<K> {
    Map<K, Record<K>> map = new HashMap<K, Record<K>>();

    @Override
    public RecordStorage put(K key, Record<K> value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Record<K> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Record<K> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public <T> void forEach(Spore<Record<K>, T> spore) {
        long now = System.currentTimeMillis();
        for (Map.Entry<K, Record<K>> next : this.map.entrySet()) {
            spore.remote(next.getValue());
            if (!spore.isFinished()) continue;
            break;
        }
        spore.finish();
    }

    public Map<K, Record<K>> getMap() {
        return this.map;
    }

    @Override
    public StorageStats getStats() {
        StorageStats stats = new StorageStats().capacity(-1L).freeMem(-1L).usedMem(-1L).numElems(this.map.size());
        return stats;
    }

    @Override
    public Stream<Record<K>> stream() {
        return this.map.entrySet().stream().map(en -> (Record)en.getValue());
    }
}

