/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import java.util.HashMap;
import java.util.Map;
import org.nustaq.reallive.impl.StorageDriver;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.interfaces.RLPredicate;
import org.nustaq.reallive.interfaces.RealLiveTable;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.Subscriber;

public class SubscribedSet<K> {
    final RealLiveTable<K> source;
    StorageDriver<K> storage;
    Subscriber<K> subs;

    public SubscribedSet(RealLiveTable<K> source) {
        this.source = source;
        this.storage = new StorageDriver(new HeapRecordStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(RLPredicate<Record<K>> filter) {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            this.unsubscribe();
            this.subs = new Subscriber<K>(null, filter, change -> {
                SubscribedSet subscribedSet = this;
                synchronized (subscribedSet) {
                    this.storage.receive(change);
                }
            });
            this.source.subscribe(this.subs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            if (this.subs != null) {
                this.source.unsubscribe(this.subs);
                this.subs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record<K> get(K key) {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            return this.storage.getStore().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Record<K>> cloneMap() {
        HashMap res = new HashMap();
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            this.storage.getStore().stream().forEach(rec -> res.put(rec.getKey(), rec));
        }
        return res;
    }
}

