/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import org.nustaq.reallive.query.CompiledQuery;
import org.nustaq.reallive.query.DoubleValue;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.FuncOperand;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.Operator;
import org.nustaq.reallive.query.QParseException;
import org.nustaq.reallive.query.QScanner;
import org.nustaq.reallive.query.Query;
import org.nustaq.reallive.query.RLSupplier;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.query.VarPath;
import org.nustaq.reallive.records.MapRecord;

public class Parser {
    HashMap<String, FuncOperand> functions;
    HashMap<String, Operator> operators;
    private final String SEPARATOR = ",";
    private Stack stackOperations = new Stack();
    private Stack stackRPN = new Stack();
    private Stack stackAnswer = new Stack();
    protected EvalContext[] ctxRef;

    Parser(HashMap<String, FuncOperand> functions, HashMap<String, Operator> operators) {
        this.functions = functions;
        this.operators = operators;
    }

    public CompiledQuery compile(String query) {
        this.ctxRef = new EvalContext[1];
        this.parse(query);
        return new CompiledQuery(this.evaluate(), this.ctxRef);
    }

    protected void parse(String expression) {
        String stringToken;
        this.stackOperations.clear();
        this.stackRPN.clear();
        QScanner scanner = new QScanner(expression);
        String prevToken = null;
        while ((stringToken = scanner.readNext()) != null) {
            if (this.isSeparator(stringToken)) {
                while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
            } else if (this.isOpenBracket(stringToken)) {
                Object last;
                Object v0 = last = this.stackRPN.isEmpty() ? null : this.stackRPN.lastElement();
                if (last instanceof VarPath && this.isFunction(((VarPath)last).field)) {
                    this.stackRPN.pop();
                    this.stackOperations.push(this.functions.get(((VarPath)last).field));
                }
                this.stackOperations.push(stringToken);
            } else if (this.isCloseBracket(stringToken)) {
                while (!this.stackOperations.empty() && !this.isOpenBracket(this.stackOperations.lastElement())) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.pop();
                if (!this.stackOperations.empty() && this.stackOperations.lastElement() instanceof FuncOperand) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
            } else if (this.isNumber(stringToken)) {
                if (stringToken.indexOf(46) < 0) {
                    Long i = Long.parseLong(stringToken);
                    this.stackRPN.push(new LongValue(i));
                } else {
                    Double d = Double.parseDouble(stringToken);
                    this.stackRPN.push(new DoubleValue(d));
                }
            } else if (this.operators.containsKey(stringToken)) {
                Operator op = this.operators.get(stringToken);
                boolean prefix = false;
                if ((stringToken.equals("+") || stringToken.equals("-")) && (prevToken == null || this.operators.containsKey(prevToken) || this.isOpenBracket(prevToken) || this.isSeparator(prevToken))) {
                    prefix = true;
                    this.stackRPN.push(new LongValue(0L));
                }
                while (!this.stackOperations.empty() && !prefix && this.stackOperations.lastElement() instanceof Operator && op.getPrecedence() <= ((Operator)this.stackOperations.lastElement()).getPrecedence()) {
                    this.stackRPN.push(this.stackOperations.pop());
                }
                this.stackOperations.push(op);
            } else if (stringToken.startsWith("'") && stringToken.endsWith("'")) {
                this.stackRPN.push(new StringValue(stringToken.substring(1, stringToken.length() - 1)));
            } else if (stringToken.startsWith("\"") && stringToken.endsWith("\"")) {
                this.stackRPN.push(new StringValue(stringToken.substring(1, stringToken.length() - 1)));
            } else {
                this.stackRPN.push(new VarPath(stringToken, this.ctxRef));
            }
            prevToken = stringToken;
        }
        while (!this.stackOperations.empty()) {
            this.stackRPN.push(this.stackOperations.pop());
        }
        Collections.reverse(this.stackRPN);
    }

    private RLSupplier<Value> evaluate() {
        if (this.stackRPN.empty()) {
            return () -> new StringValue("");
        }
        this.stackAnswer.clear();
        Stack stackRPN = (Stack)this.stackRPN.clone();
        while (!stackRPN.empty()) {
            Object token = stackRPN.pop();
            if (token instanceof Value) {
                this.stackAnswer.push(() -> token);
                continue;
            }
            if (token instanceof Operator) {
                RLSupplier a;
                int arity = ((Operator)token).getArity();
                if (arity == 2) {
                    a = (RLSupplier)this.stackAnswer.pop();
                    RLSupplier b = (RLSupplier)this.stackAnswer.pop();
                    this.stackAnswer.push(((Operator)token).getEval(a, b));
                    continue;
                }
                a = (RLSupplier)this.stackAnswer.pop();
                this.stackAnswer.push(((Operator)token).getEval(a, null));
                continue;
            }
            if (token instanceof VarPath) {
                VarPath vp = (VarPath)token;
                this.stackAnswer.push(vp.getEval());
                continue;
            }
            if (!(token instanceof FuncOperand)) continue;
            FuncOperand func = (FuncOperand)token;
            RLSupplier[] args = new RLSupplier[func.getArity()];
            for (int i = 0; i < args.length; ++i) {
                args[args.length - i - 1] = (RLSupplier)this.stackAnswer.pop();
            }
            this.stackAnswer.push(func.getEval(args));
        }
        if (this.stackAnswer.size() > 1) {
            throw new QParseException("Some operator is missing");
        }
        return (RLSupplier)this.stackAnswer.pop();
    }

    private boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isFunction(String token) {
        return this.functions.containsKey(token);
    }

    private boolean isSeparator(String token) {
        return token.equals(",");
    }

    private boolean isOpenBracket(Object token) {
        return "(".equals(token);
    }

    private boolean isCloseBracket(String token) {
        return token.equals(")");
    }

    public static void main(String[] args) throws Throwable {
        MapRecord hm = new MapRecord<String>("key").put("test", "hallo").put("a", 100).put("time", System.currentTimeMillis()).put("b", 200);
        Thread.sleep(2000L);
        CompiledQuery ctrue = Query.compile("time < age(1,\"sec\")");
        CompiledQuery cfalse = Query.compile("time < age(5,'sec')");
        CompiledQuery tim = Query.compile("a<1000000000");
        System.out.println(ctrue.evaluate(hm));
        System.out.println(cfalse.evaluate(hm));
        System.out.println(tim.evaluate(hm));
    }
}

