/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.messages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.messages.Diff;

public class ChangeUtils {
    public static Diff copyAndDiff(Record from, Record to) {
        String[] fields = from.getFields();
        return ChangeUtils.copyAndDiff(from, to, fields);
    }

    public static Diff copyAndDiff(Record from, Record to, String[] fields) {
        return ChangeUtils.mayCopyAndDiff(from, to, fields, true);
    }

    public static Diff mayCopyAndDiff(Record from, Record to, String[] fields, boolean copy) {
        ArrayList<String> changedFields = new ArrayList<String>();
        ArrayList<Object> changedValues = new ArrayList<Object>();
        for (int i = 0; i < fields.length; ++i) {
            Object newValue;
            String field = fields[i];
            Object oldValue = to.get(field);
            if (Objects.equals(oldValue, newValue = from.get(field))) continue;
            changedFields.add(field);
            changedValues.add(oldValue);
            if (!copy) continue;
            to.put(field, newValue);
        }
        String[] cf = new String[changedFields.size()];
        changedFields.toArray(cf);
        return new Diff(cf, changedValues.toArray());
    }

    public static int indexOf(String field, String[] changedFields) {
        for (int i = 0; i < changedFields.length; ++i) {
            if (!field.equals(changedFields[i])) continue;
            return i;
        }
        return -1;
    }

    public static void copy(Record from, Record to, String ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            to.put(field, from.get(field));
        }
    }

    public static String[] merge(String[] fieldsA, String[] fieldsB) {
        int i;
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < fieldsA.length; ++i) {
            set.add(fieldsA[i]);
        }
        for (i = 0; i < fieldsB.length; ++i) {
            set.add(fieldsB[i]);
        }
        String[] res = new String[set.size()];
        set.toArray(res);
        return res;
    }

    public static <K> Diff diff(Record<K> record, Record<K> prevRecord) {
        String[] fields = ChangeUtils.merge(record.getFields(), prevRecord.getFields());
        return ChangeUtils.mayCopyAndDiff(record, prevRecord, fields, false);
    }
}

