/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.interfaces;

import java.io.Serializable;
import org.nustaq.reallive.query.EvalContext;
import org.nustaq.reallive.query.StringValue;
import org.nustaq.reallive.query.Value;
import org.nustaq.reallive.records.MapRecord;

public interface Record<K>
extends Serializable,
EvalContext {
    public K getKey();

    public void key(K var1);

    public String[] getFields();

    public Record put(String var1, Object var2);

    @Override
    default public Value getValue(String field) {
        if ("_key".equals(field)) {
            return new StringValue(this.getKey().toString());
        }
        return EvalContext.super.getValue(field);
    }

    default public int getInt(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    default public long getLong(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0L;
        }
        return ((Number)val).longValue();
    }

    default public double getDouble(String field) {
        Object val = this.get(field);
        if (val == null) {
            return 0.0;
        }
        return ((Number)val).doubleValue();
    }

    default public String getString(String field) {
        Object val = this.get(field);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    default public String asString() {
        String[] fields = this.getFields();
        String res = "[  *" + this.getKey() + "  ";
        for (int i = 0; i < fields.length; ++i) {
            String s = fields[i];
            res = res + s + "=" + this.get(s) + ", ";
        }
        return res + "]";
    }

    default public boolean getBool(String field) {
        Object val = this.get(field);
        if (!(val instanceof Boolean)) {
            return false;
        }
        return (Boolean)val;
    }

    default public Record<K> reduced(String[] reducedFields) {
        MapRecord<K> rec = new MapRecord<K>(this.getKey());
        for (int i = 0; i < reducedFields.length; ++i) {
            String reducedField = reducedFields[i];
            Object val = this.get(reducedField);
            if (val == null) continue;
            rec.put(reducedField, val);
        }
        return rec;
    }

    default public Record<K> copied() {
        throw new RuntimeException("copy not implemented");
    }

    default public Object[] getKeyVals() {
        String[] fields = this.getFields();
        Object[] res = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            res[i * 2] = field;
            res[i * 2 + 1] = this.get(field);
        }
        return res;
    }
}

