/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.tablespace;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.nustaq.kontraktor.Actor;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.annotations.Local;
import org.nustaq.kontraktor.impl.SimpleScheduler;
import org.nustaq.reallive.impl.actors.RealLiveStreamActor;
import org.nustaq.reallive.impl.storage.CachedOffHeapStorage;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.impl.storage.OffHeapRecordStorage;
import org.nustaq.reallive.interfaces.RealLiveTable;
import org.nustaq.reallive.interfaces.TableDescription;
import org.nustaq.reallive.interfaces.TableSpace;
import org.nustaq.reallive.messages.StateMessage;

public class TableSpaceActor
extends Actor<TableSpaceActor>
implements TableSpace {
    HashMap<String, RealLiveTable> tables;
    HashMap<String, TableDescription> tableDesc;
    List<Callback<StateMessage>> stateListeners;
    String baseDir;

    @Local
    public void init(int numScanThreads, int numFilterThreads) {
        this.tables = new HashMap();
        this.stateListeners = new ArrayList<Callback<StateMessage>>();
        this.tableDesc = new HashMap();
    }

    public void setBaseDataDir(String dir) {
        this.baseDir = dir;
    }

    protected String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public IPromise<RealLiveTable> createOrLoadTable(TableDescription desc) {
        Supplier memFactory;
        if (this.tables.containsKey(desc.getName())) {
            return TableSpaceActor.resolve((Object)this.tables.get(desc.getName()));
        }
        RealLiveStreamActor table = (RealLiveStreamActor)Actors.AsActor(RealLiveStreamActor.class);
        if (desc.getFilePath() == null) {
            switch (desc.getType()) {
                case CACHED: {
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage<String>());
                    break;
                }
                default: {
                    memFactory = () -> new OffHeapRecordStorage(desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                    break;
                }
            }
        } else {
            String bp = this.getBaseDir() == null ? desc.getFilePath() : this.getBaseDir();
            desc.filePath(bp);
            new File(bp).mkdirs();
            switch (desc.getType()) {
                case CACHED: {
                    memFactory = () -> new CachedOffHeapStorage(new OffHeapRecordStorage(bp + "/" + desc.getName() + "_" + desc.getShardNo() + ".bin", desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries()), new HeapRecordStorage<String>());
                    break;
                }
                default: {
                    memFactory = () -> new OffHeapRecordStorage(bp + "/" + desc.getName() + "_" + desc.getShardNo() + ".bin", desc.getKeyLen(), desc.getSizeMB(), desc.getNumEntries());
                    break;
                }
                case TEMP: {
                    memFactory = () -> new HeapRecordStorage();
                }
            }
        }
        table.init(memFactory, desc);
        this.tables.put(desc.getName(), table);
        return TableSpaceActor.resolve((Object)table);
    }

    @Override
    public IPromise dropTable(String name) {
        RealLiveTable realLiveTable = this.tables.get(name);
        if (name != null) {
            this.tables.remove(name);
            ((Actor)realLiveTable).stop();
        }
        return TableSpaceActor.resolve();
    }

    @Override
    public IPromise<List<TableDescription>> getTableDescriptions() {
        return TableSpaceActor.resolve(new ArrayList<TableDescription>(this.tableDesc.values()));
    }

    @Override
    public IPromise<List<RealLiveTable>> getTables() {
        return TableSpaceActor.resolve(new ArrayList<RealLiveTable>(this.tables.values()));
    }

    @Override
    public IPromise<RealLiveTable> getTable(String name) {
        return TableSpaceActor.resolve((Object)this.tables.get(name));
    }

    @Override
    public IPromise shutDown() {
        this.tables.values().forEach(table -> table.stop());
        TableSpaceActor.stream((Object[])new SimpleScheduler[]{(SimpleScheduler)this.getScheduler()}).forEach(scheduler -> {
            scheduler.setKeepAlive(false);
            scheduler.terminateIfIdle();
        });
        return TableSpaceActor.resolve();
    }

    @Override
    public void stateListener(Callback<StateMessage> stateListener) {
        this.stateListeners.add(stateListener);
    }
}

