/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.tablespace;

import java.util.ArrayList;

public class ConsistentHash<T> {
    final int SEGMENTS = 1013;
    Object[] primary = new Object[1013];
    ArrayList<T> servers = new ArrayList();

    public ArrayList<MoveEntry<T>> addServer(T serverId) {
        ArrayList<MoveEntry<T>> res = new ArrayList<MoveEntry<T>>();
        if (this.servers.contains(serverId)) {
            return res;
        }
        this.servers.add(serverId);
        int curServers = this.servers.size();
        int step = curServers * 2;
        int count = 0;
        int i = (int)((double)step * Math.random());
        int max = 1013 / this.servers.size();
        while (count < max) {
            Object old = this.primary[i];
            if (!serverId.equals(old)) {
                this.primary[i] = serverId;
                if (old != null) {
                    res.add(new MoveEntry<Object>(i, old, serverId));
                }
                ++count;
            }
            if ((i += (int)((double)step * Math.random())) < 1013) continue;
            i -= 1013;
        }
        return res;
    }

    public void dump() {
        System.out.println("-- " + this.servers.size());
        for (int i = 0; i < this.primary.length; ++i) {
            Object o = this.primary[i];
            System.out.println("[" + i + "] " + o);
        }
    }

    public void dumpDist() {
        System.out.println("-- " + this.servers.size());
        for (int i = 0; i < this.servers.size(); ++i) {
            T t = this.servers.get(i);
            System.out.println("" + t + ": " + this.countEntries(t));
        }
    }

    public int countEntries(T serverId) {
        int res = 0;
        for (int i = 0; i < this.primary.length; ++i) {
            if (!serverId.equals(this.primary[i])) continue;
            ++res;
        }
        return res;
    }

    public static void main(String[] args) {
        ConsistentHash<String> ch = new ConsistentHash<String>();
        String[] names = new String[]{"ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "ELEVEN", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN"};
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int moved = ch.addServer(name).size();
            System.out.print("MOVED " + moved);
            ch.dumpDist();
        }
    }

    public static class MoveEntry<T> {
        int segment;
        T prevServer;
        T newServer;

        public MoveEntry(int segment, T prevServer, T newServer) {
            this.segment = segment;
            this.prevServer = prevServer;
            this.newServer = newServer;
        }

        public int getSegment() {
            return this.segment;
        }

        public T getPrevServer() {
            return this.prevServer;
        }

        public T getNewServer() {
            return this.newServer;
        }
    }
}

