/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl;

import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.impl.RLUtil;
import org.nustaq.reallive.interfaces.ChangeMessage;
import org.nustaq.reallive.interfaces.ChangeReceiver;
import org.nustaq.reallive.interfaces.Mutation;
import org.nustaq.reallive.interfaces.RLPredicate;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.RecordStorage;
import org.nustaq.reallive.messages.AddMessage;
import org.nustaq.reallive.messages.ChangeUtils;
import org.nustaq.reallive.messages.Diff;
import org.nustaq.reallive.messages.PutMessage;
import org.nustaq.reallive.messages.RemoveMessage;
import org.nustaq.reallive.messages.UpdateMessage;

public class StorageDriver<K>
implements ChangeReceiver<K>,
Mutation<K> {
    RecordStorage<K> store;
    ChangeReceiver listener;

    public StorageDriver(RecordStorage<K> store) {
        this.listener = change -> {};
        this.store = store;
        Log.Info((Object)this, (String)("" + store.getStats()));
    }

    public StorageDriver() {
        this.listener = change -> {};
    }

    @Override
    public void receive(ChangeMessage<K> change) {
        switch (change.getType()) {
            case 3: {
                break;
            }
            case 4: {
                Record<K> prevRecord = this.store.get(change.getKey());
                if (prevRecord == null) {
                    this.store.put(change.getKey(), change.getRecord());
                    this.receive(new AddMessage<K>(true, change.getRecord()));
                    break;
                }
                Diff diff = ChangeUtils.diff(change.getRecord(), prevRecord);
                Record<K> newRecord = change.getRecord();
                this.store.put(change.getKey(), newRecord);
                this.listener.receive(new UpdateMessage<K>(diff, newRecord));
                break;
            }
            case 0: {
                Record<K> prevRecord;
                AddMessage addMessage = (AddMessage)change;
                Object key = addMessage.getKey();
                if (!(key instanceof String)) {
                    boolean newRecord = true;
                }
                if ((prevRecord = this.store.get(key)) != null && !addMessage.isUpdateIfExisting()) {
                    return;
                }
                if (prevRecord != null) {
                    Diff diff = ChangeUtils.copyAndDiff(addMessage.getRecord(), prevRecord);
                    Record<K> newRecord = prevRecord;
                    this.store.put(change.getKey(), newRecord);
                    this.listener.receive(new UpdateMessage<K>(diff, newRecord));
                    break;
                }
                this.store.put(change.getKey(), addMessage.getRecord());
                this.listener.receive(addMessage);
                break;
            }
            case 1: {
                RemoveMessage removeMessage = (RemoveMessage)change;
                Record<K> v = this.store.remove(removeMessage.getKey());
                if (v == null) break;
                this.listener.receive(new RemoveMessage<K>(v));
                break;
            }
            case 2: {
                UpdateMessage updateMessage = (UpdateMessage)change;
                Record<K> oldRec = this.store.get(updateMessage.getKey());
                if (oldRec == null && updateMessage.isAddIfNotExists()) {
                    if (updateMessage.getNewRecord() == null) {
                        throw new RuntimeException("updated record does not exist, cannot fall back to 'Add' as UpdateMessage.newRecord is null");
                    }
                    this.store.put(change.getKey(), updateMessage.getNewRecord());
                    this.listener.receive(new AddMessage(updateMessage.getNewRecord()));
                    break;
                }
                if (updateMessage.getDiff() == null) {
                    Diff diff = ChangeUtils.copyAndDiff(updateMessage.getNewRecord(), oldRec);
                    Record<K> newRecord = oldRec;
                    this.store.put(change.getKey(), newRecord);
                    this.listener.receive(new UpdateMessage<K>(diff, newRecord));
                    break;
                }
                Diff newDiff = ChangeUtils.copyAndDiff(updateMessage.getNewRecord(), oldRec, updateMessage.getDiff().getChangedFields());
                Record<K> newRecord = oldRec;
                this.store.put(change.getKey(), newRecord);
                this.listener.receive(new UpdateMessage<K>(newDiff, newRecord));
                break;
            }
            default: {
                throw new RuntimeException("unknown change type " + change.getType());
            }
        }
    }

    public RecordStorage<K> getStore() {
        return this.store;
    }

    public ChangeReceiver getListener() {
        return this.listener;
    }

    public StorageDriver store(RecordStorage<K> store) {
        this.store = store;
        return this;
    }

    public StorageDriver setListener(ChangeReceiver listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public IPromise<Boolean> putCAS(RLPredicate<Record<K>> casCondition, K key, Object ... keyVals) {
        Record<K> kRecord = this.getStore().get(key);
        if (casCondition == null || casCondition.test(kRecord)) {
            this.put(key, keyVals);
            return new Promise((Object)true);
        }
        return new Promise((Object)false);
    }

    @Override
    public void put(K key, Object ... keyVals) {
        this.receive(RLUtil.get().put(key, keyVals));
    }

    @Override
    public void addOrUpdate(K key, Object ... keyVals) {
        this.receive(RLUtil.get().addOrUpdate(key, keyVals));
    }

    @Override
    public void add(K key, Object ... keyVals) {
        this.receive(RLUtil.get().add(key, keyVals));
    }

    @Override
    public void add(Record<K> rec) {
        this.receive(new AddMessage<K>(rec));
    }

    @Override
    public void addOrUpdateRec(Record<K> rec) {
        this.receive(new AddMessage<K>(true, rec));
    }

    @Override
    public void put(Record<K> rec) {
        this.receive(new PutMessage<K>(rec));
    }

    @Override
    public void update(K key, Object ... keyVals) {
        this.receive(RLUtil.get().update(key, keyVals));
    }

    @Override
    public void remove(K key) {
        RemoveMessage<K> remove = RLUtil.get().remove(key);
        this.receive(remove);
    }
}

