/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.webserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.nustaq.netty2go.NettyWSHttpServer;
import org.nustaq.webserver.ClientSession;

public class WebSocketHttpServer {
    protected final AttributeKey<ClientSession> session = AttributeKey.valueOf((String)"session");
    public static Logger logger = Logger.getLogger(WebSocketHttpServer.class.getName());
    protected File contentRoot;

    public WebSocketHttpServer(File contentRoot) {
        this.contentRoot = contentRoot;
    }

    public void onOpen(ChannelHandlerContext ctx) {
        ctx.attr(this.session).set((Object)this.createNewSession());
        logger.info("onOpen: " + ctx.attr(this.session).get());
    }

    public void onClose(ChannelHandlerContext ctx) {
        logger.info("close session on:" + ctx.attr(this.session).get() + " closed.");
    }

    public void onHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender) {
        logger.info("request on:" + ctx.attr(this.session));
        this.serveFile(ctx, req, sender);
    }

    public void onTextMessage(ChannelHandlerContext ctx, String text) {
        logger.info("text on:" + ctx.attr(this.session) + " '" + text + "'");
        this.sendWSTextMessage(ctx, text);
    }

    public void onBinaryMessage(ChannelHandlerContext ctx, byte[] buffer) {
        logger.info("binary on:" + ctx.attr(this.session));
    }

    protected ClientSession getSession(ChannelHandlerContext ctx) {
        return (ClientSession)ctx.attr(this.session).get();
    }

    protected ClientSession createNewSession() {
        ClientSession clientSession = new ClientSession(){};
        logger.info("created session " + clientSession);
        return clientSession;
    }

    public void sendWSTextMessage(ChannelHandlerContext ctx, String s) {
        ctx.channel().write((Object)new TextWebSocketFrame(s));
    }

    public void sendWSBinarayMessage(ChannelHandlerContext ctx, byte[] b, int off, int len) {
        ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len)));
    }

    public void sendWSBinarayMessage(ChannelHandlerContext ctx, byte[] b) {
        ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])b, (int)0, (int)b.length)));
    }

    public void sendHttpGetResponse(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender, String response) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.US_ASCII);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        res.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
        sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveFile(ChannelHandlerContext ctx, FullHttpRequest req, NettyWSHttpServer.HttpResponseSender sender) {
        File target = new File(this.contentRoot, File.separator + req.getUri().toString());
        if (target.exists() && target.isFile()) {
            AbstractInterruptibleChannel inChannel = null;
            RandomAccessFile aFile = null;
            try {
                aFile = new RandomAccessFile(target, "r");
                inChannel = aFile.getChannel();
                long fileSize = ((FileChannel)inChannel).size();
                ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                while (((FileChannel)inChannel).read(buffer) > 0) {
                }
                buffer.flip();
                ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)buffer);
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                res.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
                HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
                sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (aFile != null) {
                        aFile.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        } else {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            sender.sendHttpResponse(ctx, req, (FullHttpResponse)res);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8887;
        new NettyWSHttpServer(port, new WebSocketHttpServer(new File("."))).run();
    }
}

