/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.netty2go;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.nustaq.webserver.WebSocketHttpServer;

public class NettyWSHttpServer {
    public static Logger logger = Logger.getLogger(WebSocketServerHandler.class.getName());
    public static String WEBSOCKET_PATH = "/websocket";
    private final int port;
    private WebSocketHttpServer httpReceiver;

    public NettyWSHttpServer(int port, WebSocketHttpServer receiver) {
        this.port = port;
        this.httpReceiver = receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitializer());
            Channel ch = b.bind(this.port).sync().channel();
            logger.info("Web socket server started at port " + this.port + '.');
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public class WebSocketServerHandler
    extends SimpleChannelInboundHandler<Object>
    implements HttpResponseSender {
        private WebSocketServerHandshaker handshaker;

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof FullHttpRequest) {
                this.handleHttpRequest(ctx, (FullHttpRequest)msg);
            } else if (msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        private void handleHttpRequest(final ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
            if (!req.getDecoderResult().isSuccess()) {
                this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
                return;
            }
            if (req.getMethod() != HttpMethod.GET) {
                this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                return;
            }
            if (!WEBSOCKET_PATH.equals(req.getUri())) {
                NettyWSHttpServer.this.httpReceiver.onHttpRequest(ctx, req, this);
                return;
            }
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), null, false);
            this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        NettyWSHttpServer.this.httpReceiver.onOpen(ctx);
                    }
                });
            }
        }

        private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
            if (frame instanceof CloseWebSocketFrame) {
                this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
                NettyWSHttpServer.this.httpReceiver.onClose(ctx);
                return;
            }
            if (frame instanceof PingWebSocketFrame) {
                ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
                return;
            }
            if (frame instanceof BinaryWebSocketFrame) {
                ByteBuf rawMessage = frame.content();
                int size = rawMessage.readableBytes();
                byte[] buffer = new byte[size];
                rawMessage.readBytes(buffer);
                NettyWSHttpServer.this.httpReceiver.onBinaryMessage(ctx, buffer);
                return;
            }
            if (frame instanceof TextWebSocketFrame) {
                NettyWSHttpServer.this.httpReceiver.onTextMessage(ctx, ((TextWebSocketFrame)frame).text());
                return;
            }
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }

        @Override
        public void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
            if (res.getStatus().code() != 200) {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8);
                res.content().writeBytes(buf);
                buf.release();
                HttpHeaders.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
            }
            ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
            if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().code() != 200) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
            ctx.close();
        }

        private String getWebSocketLocation(FullHttpRequest req) {
            return "ws://" + req.headers().get("Host") + WEBSOCKET_PATH;
        }
    }

    public static interface HttpResponseSender {
        public void sendHttpResponse(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);
    }

    public class WebSocketServerInitializer
    extends ChannelInitializer<SocketChannel> {
        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("codec-http", (ChannelHandler)new HttpServerCodec());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
            WebSocketServerHandler handler = new WebSocketServerHandler();
            pipeline.addLast("handler", (ChannelHandler)handler);
        }
    }
}

